// Bomberman version 2
// Program and art by Tevong(c)


PROGRAM Bomberman;


GLOBAL
    bomb_time=40;
    bomb_size[5]=3;
    bomb_num; // number of bombs placed
    exp_time; //explosion time
    end_exp[150]; //to let all processes know when explosion ends
    struct id_exp[150]; //explosion graphic processes
        id_proc[150]; //for called graphic process within explosion process
    end
    //flag variables to know when explosion hits unbreakable block
    put_right[150];
    put_left[150];
    put_up[150];
    put_down[150];
    exp_ended[150]; //to know when explosion ended for each num process son
    id_sound_exp; //explosion sound id
    placed_bomb[5]; //number of placed bombs for players
    //CONSTANTS
    max_bomb[5];



    level1[192]= 6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,  //0= nothing
                 6,2,0,7,7,7,7,7,7,7,7,7,7,0,0,6,  //1=explosion graphic
                 6,0,6,7,6,7,6,7,7,6,7,6,7,6,0,6,  //2=player1
                 6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,  //3=player2
                 6,7,7,7,7,7,7,0,0,7,7,7,7,7,7,6,  //4=player3
                 6,7,6,7,6,7,6,0,0,6,7,6,7,6,7,6,  //5=player4
                 6,7,7,7,0,0,7,0,0,7,0,0,7,7,7,6,  //6=unbreakable blocks
                 6,7,7,7,0,0,7,0,0,7,0,0,7,7,7,6,  //7=breakable blocks
                 6,7,6,7,6,7,6,7,7,6,7,6,7,6,7,6,  //8=bomb
                 6,0,7,7,7,7,7,0,0,7,7,7,7,7,0,6,  //9=power up
                 6,0,0,7,7,7,0,0,0,0,7,7,7,0,3,6,
                 6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6;


    power_up[192]=0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,  //0=nothing
                  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,  //1=more bomb
                  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,  //2=
                  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,  //3=
                  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,  //4=
                  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,  //5=
                  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,  //6=
                  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,  //7=
                  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,  //8=
                  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
                  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
                  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;


    level=1; //which level player is on




PRIVATE
    counter;
    counter_x;
    counter_y;
    player1_x; //starting position of player 1
    player1_y;
    player2_x; //starting position of player 2
    player2_y;
    breakable_block; //random number assigned for breakable block
    rand_num; //random number for power ups


BEGIN
    //-------------------------------------------------------------------
    //initialization-----------------------------------------------------
    //-------------------------------------------------------------------

    set_mode(m800x600);
    load_fpg("bomberma.fpg");
    id_sound_exp=load_pcm("explosio.pcm",0); //loads sound, 0 means don't repeat play

    //initialising max num and exp size of bombs placed
    for(counter=0; counter<5 ; counter++)
        max_bomb[counter]=1;
        bomb_size[counter]=2;
    end


    //put plain background
    for(counter_x=0 ; counter_x<800 ; counter_x+=50)
        for(counter_y=0 ; counter_y<600 ; counter_y+=50)

            put(0,6,counter_x,counter_y);

            frame;

        end
    end


    counter_x=-1; //because 0 is 1 so it starts one behind
    counter_y=0;
    breakable_block=7; //wall graphic for breakable block

    // read data from table
    for(counter=0; counter<193; counter++)

        //read first line of table, along x
        counter_x++;

        //if it reaches end of x of table
        if(counter_x==16)

            counter_x=0; //then start back at beginning
            counter_y++; //on second line of y

        end



        //decodes data from tables and executes them -------------------------

        SWITCH (level)

         CASE 1:


            if(level1[counter]==7) //7=breakable block

                put(0,breakable_block,counter_x*50,counter_y*50);

                //puts random power up
                rand_num=rand(0,12);

                switch (rand_num)
                 case 2,3: //1=add bombs
                    power_up[counter]=1;
                 end
                 case 5: //2=increases explosion size
                    power_up[counter]=2;
                 end
                end

            end

            if(level1[counter]==6) //6=unbreakable block

                put(0,2,counter_x*50,counter_y*50);

            end


            if(level1[counter]==2) //2=player 1

                player1_x=counter_x*50;
                player1_y=counter_y*50;
                level1[counter]=0;

            end

            if(level1[counter]==3) //3=player 2

                player2_x=counter_x*50;
                player2_y=counter_y*50;
                level1[counter]=0;

            end


         END //of level1 case

        END //of SWITCH

        //--------------------------------------------------------------------



        frame;


    end //of for loop


    //-----------------------------------------------------------------------
    //end of initialisation--------------------------------------------------
    //------------------------------------------------------------------------


    //call processes
    player1(player1_x,player1_y);
    player2(player2_x,player2_y);
    //if(player2_type==1) comp(); end //if player2 is computer


    while(not key(_x))

        frame;

    end




END


//---------------------------------------------------------------------------
//PLAYER1--------------------------------------------------------------------
//---------------------------------------------------------------------------
PROCESS player1(x,y);

PRIVATE
    counter;
    counter_x;
    counter_y;
    move_up;
    move_down;
    move_left;
    move_right;
    check_pos; //scale down x position for table (divide by 50)
    check_x;
    check_y;
    check_pos_down;
    bomb;
    anim_ctr_up; //animation counter
    anim_ctr_down;
    anim_ctr_right;
    anim_ctr_left;
    key_up; //time key up is pressed down
    key_down;
    key_right;
    key_left;
    key_enter;
    speed; //speed of player


BEGIN
    graph=8; //Ku Klux graphic


    speed=3; //default speed


    LOOP //main loop--------------------------------------------------------


        check_x=(x/50);
        check_y=(y/50);
        //formula to get position number of player on level data table
        check_pos=(check_y*16)+(check_x);


        //check for collision with explosion
        if(level1[check_pos]==5)

            exit("PLAYER 1 DIED (didn't have time to do death animation...",0); //death

        end


        //input key
        if(key(_up) and not key(_right))
         if(not key(_left))   //so it won't go in diagonal

            key_up++; //amount of time it is pressed down increases

            if(key_up<2) //if it wasn't pressed down for too long
                move_up=1;
            end

            if(key_up==speed) key_up=0; end //how long to wait before letting it move again

         end
        else
            key_up=0;
        end

        if(key(_down) and not key(_right))
         if(not key(_left))

            key_down++;

            if(key_down<2)
                move_down=1;
            end

            if(key_down==speed) key_down=0; end

         end
        else
            key_down=0;
        end

        if(key(_right) and not key(_up))
         if(not key(_down))

            key_right++;

            if(key_right<2)
                move_right=1;
            end

            if(key_right==speed) key_right=0; end

         end
        else
            key_right=0;
        end

        if(key(_left) and not key(_up))
         if(not key(_down))

            key_left++;

            if(key_left<2)
               move_left=1;
            end

            if(key_left==speed) key_left=0; end

         end
        else
            key_left=0;
        end

        if(key(_enter))

            key_enter++;

            if(key_enter<2) //so bombs won't be placed right after each other
                bomb=1;
            end

            if(key_enter==3) key_enter=0; end

        else
            if(not key(_right) and not key(_left)) //so when other buttons pressed
             if(not key(_up) and not key(_down)) //key_enter will till keep going
                key_enter=0;
             end
            end
        end


        //collision detection and executing moves

        if(move_up==1)

            if(level1[check_pos-16]<6)
                y-=50;
                anim_ctr_up++; //animation
                anim_ctr_down=0;
                anim_ctr_right=0;
                anim_ctr_left=0;
            end

        end

        if(move_down==1)

            if(level1[(check_pos+16)]<6)
                y+=50;
                anim_ctr_down++;
                anim_ctr_up=0;
                anim_ctr_right=0;
                anim_ctr_left=0;
            end

        end

        if(move_right==1)

            if(level1[check_pos+1]<6)
                x+=50;
                anim_ctr_right++;
                anim_ctr_left=0;
                anim_ctr_up=0;
                anim_ctr_down=0;
            end

        end

        if(move_left==1)

            if(level1[check_pos-1]<6)
                x-=50;
                anim_ctr_left++;
                anim_ctr_right=0;
                anim_ctr_up=0;
                anim_ctr_down=0;
             end

        end

        if(bomb==1)

            if(level1[check_pos]<>8) //so it doesn't put bomb on top of other bomb
                if(bomb_num==50) //so bomb_num doesn't go "over the top" (2340..)
                    bomb_num=0;
                end

                if(placed_bomb[1]<max_bomb[1])
                    placed_bomb[1]+=1; //number of placed bombs
                    bomb_num++; //id for different processes which are the same
                    bombit(x,y,bomb_time,bomb_size[1],bomb_num,1);
                    //x,y,bomb time,exp size, id num,and player num
                end
            end

            bomb=0;

        end

        //end of collision detection and executing moves

        //POWER UPS-----------------------------------------

        //more bombs power up
        if(power_up[check_pos]==1) //1 is more bombs
            max_bomb[1]++;
            power_up[check_pos]=0;
            put(0,6,x,y); //puts blank when picked up power up
        end

        //explosion size increase
        if(power_up[check_pos]==2)
            bomb_size[1]++;
            power_up[check_pos]=0;
            put(0,6,x,y);
        end



        //---------------------------------------------------

        //animation
        switch (anim_ctr_up) //upwards animation
         case 1:
            graph=14; //behind graph
         end
         case 2;
            graph=15; //behind graph
            anim_ctr_up=0;
         end
        end

        switch (anim_ctr_down) //downwards animation
         case 1:
            graph=8;  //front view
         end
         case 2:
            graph=9;
            anim_ctr_down=0;
         end
        end

        switch (anim_ctr_right) //right animation
         case 1:
            graph=12;  //right view
         end
         case 2:
            graph=13;
            anim_ctr_right=0;
         end
        end

        switch (anim_ctr_left) //left animation
         case 1:
            graph=10;  //left view
         end
         case 2:
            graph=11;
            anim_ctr_left=0;
         end
        end


        move_up=0;
        move_down=0;
        move_left=0;
        move_right=0;
        counter=0;
        counter_x=0;
        counter_y=0;


        frame;


    END //end of main loop-----------------------------------------------


END

//END OF PLAYER 1------------------------------------------------------------



//---------------------------------------------------------------------------
//PLAYER2--------------------------------------------------------------------
//---------------------------------------------------------------------------
PROCESS player2(x,y);

PRIVATE
    counter;
    counter_x;
    counter_y;
    move_up;
    move_down;
    move_left;
    move_right;
    check_pos; //scale down x position for table (divide by 50)
    check_x;
    check_y;
    check_pos_down;
    bomb;
    anim_ctr_up; //animation counter
    anim_ctr_down;
    anim_ctr_right;
    anim_ctr_left;
    key_up; //time key up is pressed down
    key_down;
    key_right;
    key_left;
    key_r;
    speed; //speed of player


BEGIN
    graph=8; //Ku Klux graphic


    speed=3; //default speed


    LOOP //main loop--------------------------------------------------------


        check_x=(x/50);
        check_y=(y/50);
        //formula to get position number of player on level data table
        check_pos=(check_y*16)+(check_x);


        //check for collision with explosion
        if(level1[check_pos]==5)

            exit("PLAYER 2 DIED",0); //death

        end


        //input key
        if(key(_w) and not key(_d)) //w is up
         if(not key(_a))   //so it won't go in diagonal

            key_up++; //amount of time it is pressed down increases

            if(key_up<2) //if it wasn't pressed down for too long
                move_up=1;
            end

            if(key_up==speed) key_up=0; end //how long to wait before letting it move again

         end
        else
            key_up=0;
        end

        if(key(_s) and not key(_d)) //s is down
         if(not key(_a))

            key_down++;

            if(key_down<2)
                move_down=1;
            end

            if(key_down==speed) key_down=0; end

         end
        else
            key_down=0;
        end

        if(key(_d) and not key(_w)) //d is right
         if(not key(_s))

            key_right++;

            if(key_right<2)
                move_right=1;
            end

            if(key_right==speed) key_right=0; end

         end
        else
            key_right=0;
        end

        if(key(_a) and not key(_w)) //a is left
         if(not key(_s))

            key_left++;

            if(key_left<2)
               move_left=1;
            end

            if(key_left==speed) key_left=0; end

         end
        else
            key_left=0;
        end

        if(key(_r))

            key_r++;

            if(key_r<2) //so bombs won't be placed right after each other
                bomb=1;
            end

            if(key_r==3) key_r=0; end

        else
            if(not key(_d) and not key(_a)) //so when other buttons pressed
             if(not key(_w) and not key(_s)) //key_enter will keep going
                key_r=0;
             end
            end
        end


        //collision detection and executing moves

        if(move_up==1)

            if(level1[check_pos-16]<6)
                y-=50;
                anim_ctr_up++; //animation
                anim_ctr_down=0;
                anim_ctr_right=0;
                anim_ctr_left=0;
            end

        end

        if(move_down==1)

            if(level1[(check_pos+16)]<6)
                y+=50;
                anim_ctr_down++;
                anim_ctr_up=0;
                anim_ctr_right=0;
                anim_ctr_left=0;
            end

        end

        if(move_right==1)

            if(level1[check_pos+1]<6)
                x+=50;
                anim_ctr_right++;
                anim_ctr_left=0;
                anim_ctr_up=0;
                anim_ctr_down=0;
            end

        end

        if(move_left==1)

            if(level1[check_pos-1]<6)
                x-=50;
                anim_ctr_left++;
                anim_ctr_right=0;
                anim_ctr_up=0;
                anim_ctr_down=0;
             end

        end

        if(bomb==1)

            if(level1[check_pos]<>8) //so it doesn't put bomb on top of other bomb
                if(bomb_num==50) //so bomb_num doesn't go "over the top" (2340..)
                    bomb_num=0;
                end

                if(placed_bomb[2]<max_bomb[2])
                    placed_bomb[2]+=1; //number of placed bombs
                    bomb_num++; //id for different processes which are the same
                    bombit(x,y,bomb_time,bomb_size[2],bomb_num,2);
                    //x,y,bomb time,it's exp size, id num, and player num
                end
            end

            bomb=0;

        end

        //end of collision detection and executing moves

        //POWER UPS-----------------------------------------

        //more bombs power up
        if(power_up[check_pos]==1) //1 is more bombs
            max_bomb[2]++;
            power_up[check_pos]=0;
            put(0,6,x,y); //puts blank when picked up power up
        end

        //explosion size increase
        if(power_up[check_pos]==2)
            bomb_size[2]++;
            power_up[check_pos]=0;
            put(0,6,x,y);
        end



        //---------------------------------------------------

        //animation
        switch (anim_ctr_up) //upwards animation
         case 1:
            graph=14; //behind graph
         end
         case 2;
            graph=15; //behind graph
            anim_ctr_up=0;
         end
        end

        switch (anim_ctr_down) //downwards animation
         case 1:
            graph=8;  //front view
         end
         case 2:
            graph=9;
            anim_ctr_down=0;
         end
        end

        switch (anim_ctr_right) //right animation
         case 1:
            graph=12;  //right view
         end
         case 2:
            graph=13;
            anim_ctr_right=0;
         end
        end

        switch (anim_ctr_left) //left animation
         case 1:
            graph=10;  //left view
         end
         case 2:
            graph=11;
            anim_ctr_left=0;
         end
        end


        move_up=0;
        move_down=0;
        move_left=0;
        move_right=0;
        counter=0;
        counter_x=0;
        counter_y=0;


        frame;


    END //end of main loop-----------------------------------------------


END
//END OF PLAYER 1------------------------------------------------------------





PROCESS bombit(x,y,time,exp_size,num,player_id);

PRIVATE
    time;
    exp_size; //explosion size
    counter;  //counters for graphic placement
    counter_x;
    counter_y;
    counter_x2;
    counter_y2;
    num; //bomb_num pointer
    proc_num; //number of each id_exp
    anim_counter; //counter for animation frames
    player_id; //so we know bomb is for which player


BEGIN

    exp_ended[num]=1; //started
    level1[(x/50)+((y/50)*16)]=8;
    graph=4;
    size=100;

    LOOP //time before explosion

        counter++;
        anim_counter++;

        if(counter==time) break; end
        if(level1[(x/50)+((y/50)*16)]==5) break; end

        //animation for bomb
        switch(anim_counter)
         case 0..5:
            size=100;
         end
         default:
            size=75;
            if(anim_counter==8) anim_counter=0; end
         end
        end

        frame;


    END

    graph=0; //bomb explodes,no more graphic

    counter_x2=x;
    counter_y2=y;
    counter_y=y;
    proc_num=0;


    sound(id_sound_exp,128,256); //plays explosion sound


    //explosion
    for (counter_x=x ; counter_x<x+(exp_size*50) ; counter_x+=50)


        id_exp[num].id_proc[proc_num]=put_graph(num,x,y,counter_x,counter_y,counter_x2,counter_y2);

        frame;

        counter_y+=50;
        counter_x2-=50;
        counter_y2-=50;
        proc_num++;

    end


    //time explosion graphic is shown
    from counter=0 to 14;

        frame;

    end

    exp_ended[num]=0; //ended


    //reset everything
    for(counter=0 ; counter<proc_num ; counter++)

        //deletes explosion graphic processes
        signal(id_exp[num].id_proc[counter],s_kill_tree);

    end


    put_down[bomb_num]=0;
    put_up[bomb_num]=0;
    put_right[bomb_num]=0;
    put_left[bomb_num]=0;
    placed_bomb[player_id]-=1;



    //reset counters
    counter_x=-1;
    counter_y=0;

    //deletes bomb data since bomb exploded (bomb num is 5)
    // read data from table
    for(counter=0; counter<193; counter++)

        //read first line of table, along x
        counter_x++;


        //if it reaches end of x of table
        if(counter_x==16)

            counter_x=0; //then start back at beginning
            counter_y++; //on second line of y

        end



        if(level1[counter]==5) //5=explosion graphic

            level1[counter]=0; //bomb num 5 is back to 0

        end


        frame;


    end //of for




END

//Explosion graphs
PROCESS put_graph(num,x,y,counter_x,counter_y,counter_x2,counter_y2);

PRIVATE
    counter_x;
    counter_y;
    counter_x2;
    counter_y2;
    num;
    counter;
    counter2;
    del_x[5]; //coord of data to be set back to 0
    del_y[5];
    clear_block[5]; //to know if there is block before to put blank on top
    clear_x[150];
    clear_y[150];

BEGIN

    //places explosion graphics
    if(level1[(counter_x2/50)+((y/50)*16)]<>6 and put_left[num]==0) //checks for unbreakable blocks

        //if breakable block is there then put graphic but don't continue after
        if(level1[(counter_x2/50)+((y/50)*16)]==7)
            put_left[num]=1;
        end

        put_graph2(counter_x2,y); //places graphic going left
        if(level1[(counter_x2/50)+((y/50)*16)]==7)
            clear_block[counter]=1;    //so if there was a block before
            clear_x[counter]=counter_x2; //after explosion clear will be put
            clear_y[counter]=y;
        end
        level1[(counter_x2/50)+((y/50)*16)]=5; //sets explosion pos in data table
        del_x[counter]=counter_x2/50;
        del_y[counter]=y/50;
        counter++;
    else
        put_left[num]=1; //so graphic isn't put past unbreakable block
    end

    if(counter_y<600) //so won't "acces out of range"
     if(level1[(x/50)+((counter_y/50)*16)]<>6 and put_down[num]==0)

        if(level1[(x/50)+((counter_y/50)*16)]==7)
            put_down[num]=1;
        end

        put_graph2(x,counter_y); //places graphic going down
        if(level1[(x/50)+((counter_y/50)*16)]==7)
            clear_block[counter]=1;
            clear_x[counter]=x;
            clear_y[counter]=counter_y;
        end
        level1[(x/50)+((counter_y/50)*16)]=5;
        del_x[counter]=x/50;
        del_y[counter]=counter_y/50;
        counter++;
     else
        put_down[num]=1;
     end
    end

    if(counter_y2>0) //so won't "access out of range"
     if(level1[(x/50)+((counter_y2/50)*16)]<>6 and put_up[num]==0)

        if(level1[(x/50)+((counter_y2/50)*16)]==7)
            put_up[num]=1;
        end

        put_graph2(x,counter_y2); //places graphic going up
        if(level1[(x/50)+((counter_y2/50)*16)]==7)
            clear_block[counter]=1;
            clear_x[counter]=x;
            clear_y[counter]=counter_y2;
        end
        level1[(x/50)+((counter_y2/50)*16)]=5;
        del_x[counter]=x/50;
        del_y[counter]=counter_y2/50;
        counter++;
     else
        put_up[num]=1;
     end
    end


    if(level1[(counter_x/50)+((y/50)*16)]<>6 and put_right[num]==0)

        if(level1[(counter_x/50)+((y/50)*16)]==7)
            put_right[num]=1;
        end

        put_graph2(counter_x,y); //places graphic going right
        if(level1[(counter_x/50)+((y/50)*16)]==7)
            clear_block[counter]=1;
            clear_x[counter]=counter_x;
            clear_y[counter]=y;
        end
        level1[(counter_x/50)+((y/50)*16)]=5;

        del_x[counter]=counter_x/50;
        del_y[counter]=y/50;
    else
        put_right[num]=1;
    end


    //time explosion remains lethal
    from counter=0 to 13;

        frame;

    end


    //resets number 5 in data table back to 0
    //and places power ups
    for(counter2=0 ; counter2<5 ; counter2++)

        level1[del_x[counter2]+(del_y[counter2]*16)]=0; //level1 pos = 0

        if(clear_block[counter2]=1)

            if(clear_x[counter2]<>0 and clear_y[counter2]<>0) //so doesnt put at 0,0

                //POWER UPS----------------------------------------------

                //clears breakable block first
                put(0,6,clear_x[counter2],clear_y[counter2]); //puts blank instead of block


                //increases bomb num
                if(power_up[(clear_x[counter2]/50)+((clear_y[counter2]/50)*16)]==1)
                    put(0,16,clear_x[counter2],clear_y[counter2]);
                end //puts more bombs power up

                //increases bomb explosion size
                if(power_up[(clear_x[counter2]/50)+((clear_y[counter2]/50)*16)]==2)
                    put(0,1,clear_x[counter2],clear_y[counter2]);
                end


            end

        end

    end


    loop

        frame;

    end

END
//part of explosion process, this process is each graphic
PROCESS put_graph2(x,y);

PRIVATE

BEGIN
    graph=5;

    loop

        frame;

    end
END











