/*
    Title  : RPG tutor - Hardness MAP
    Author : Mario
    Date   : November 2000
    Length : Over 100 lines

    Author note : I create this tutor to help those RPG fans, 'coz I've seen
                  a lot of desperate request, S.O.S, mayday, help, etc on the
                  DIV-ARENA Message Board and most of them about hardness map

    PLEASE READ THIS!!

    When you run this program, try to move the red hair boy to the outside
    wall of the house (left or right).  You will see that the boy's head
    were placed above the house.  It's not pretty!  That is because I draw
    the house and put it as background.  Should you want a better view,
    I have save the big house's graphic and the small house's graphic inside
    the FPG file.  You must create your own process that will show the houses.

    Their coordinates are :
        Big house x=160 y=215 z=y*-1;
        Small house x=20 y=80 z=y*-1;

    After that, at this statement inside big_map, big_house and small_house
    processes...

        z=y*-1;
*/

Program rpg_tut;
Global
    boy_s[]=1,2,3,4,1,5,6,7,1; //this is the animation when you press up
    boy_n[]=8,9,10,11,8,12,13,14,8; //... when you press down
    boy_we[]=15,16,17,18,15,19,20,21,15;//... when you press left or right

    play_state; //to indicate where you are
    last_graph=1; //save last graph being used
    last_x; //save last x position
    last_y; //... y pos
    new_x=155; //new x position
    new_y=200; //... y pos
    pixel; //pixel captured using map_get_pixel
    walk_speed=2; //change this if you want, try not setting it too high

Begin
    set_mode(m320x240);
    load_fpg("rpg.fpg");
    Loop
        Switch(play_state)
            Case 0 : let_me_alone(); big_map(new_x,new_y); End
            Case 1 : let_me_alone(); big_house(new_x,new_y); End
            Case 2 : let_me_alone(); small_house(new_x,new_y); End
            Case 3 : Exit("Good luck!",0); End
        End
        Frame;
    End
End

Process big_map(x,y);
Private;
    counter;
Begin
    play_state=-1;
    graph=last_graph;
    put_screen(0,22);
    Loop
        last_x=x; //saves x to last_x
        last_y=y; //...y to last_y
        //This can be very confusing, but the purpose is to prevent you from
        //pressing two or more movement buttons at the same time.
        If (key(_up)) flags=0; y-=walk_speed;counter++; graph=boy_n[counter];
        Else
            If (key(_down)) flags=0; y+=walk_speed;counter++; graph=boy_s[counter];
            Else
                If (key(_left)) flags=1; x-=walk_speed;;counter++; graph=boy_we[counter];
                Else
                    If (key(_right)) flags=0; x+=walk_speed;;counter++; graph=boy_we[counter]; End
                End
            End
        End
        If (counter>7) counter=0; End
        //check hardness map, the rest is easy, you should be able to
        //understand them...
        pixel=map_get_pixel(0,23,x,y);
        Switch(pixel)
            Case 255: x=last_x; y=last_y; End
            Case 254: new_x=160;new_y=219;play_state=1; End
            Case 253: new_x=18;new_y=80;play_state=2; End
            Case 252: walk_speed=3; End
            Case 251: play_state=3; End
            Case 250: x=36;y=10; End
            Case 249: x=8;y=141; End
            Default : walk_speed=2; End
        End
        last_graph=graph;
        Frame;
    End
End


Process big_house(x,y);
Private;
    counter;
Begin
    play_state=-1;
    graph=last_graph;
    put_screen(0,26);
    Loop
        last_x=x;
        last_y=y;
        If (key(_up)) flags=0; y-=walk_speed;;counter++; graph=boy_n[counter];
        Else
            If (key(_down)) flags=0; y+=walk_speed;;counter++; graph=boy_s[counter];
            Else
                If (key(_left)) flags=1; x-=walk_speed;;counter++; graph=boy_we[counter];
                Else
                    If (key(_right)) flags=0; x+=walk_speed;;counter++; graph=boy_we[counter]; End
                End
            End
        End
        If (counter>7) counter=0; End
        pixel=map_get_pixel(0,28,x,y);
        Switch(pixel)
            Case 255: x=last_x; y=last_y; End
            Case 254: new_x=157;new_y=129;play_state=0; End
            Case 253: new_x=147;new_y=66;play_state=2; End
            Default : walk_speed=2; End
        End
        last_graph=graph;
        Frame;
    End
End


Process small_house(x,y);
Private;
    counter;
Begin
    play_state=-1;
    graph=last_graph;
    put_screen(0,27);
    Loop
        last_x=x;
        last_y=y;
        If (key(_up)) flags=0; y-=walk_speed;;counter++; graph=boy_n[counter];
        Else
            If (key(_down)) flags=0; y+=walk_speed;;counter++; graph=boy_s[counter];
            Else
                If (key(_left)) flags=1; x-=walk_speed;;counter++; graph=boy_we[counter];
                Else
                    If (key(_right)) flags=0; x+=walk_speed;;counter++; graph=boy_we[counter]; End
                End
            End
        End
        If (counter>7) counter=0; End
        pixel=map_get_pixel(0,29,x,y);
        Switch(pixel)
            Case 255: x=last_x; y=last_y; End
            Case 254: new_x=252;new_y=188;play_state=0; End
            Case 253: new_x=271;new_y=76;play_state=1; End
            Default : walk_speed=2; End
        End
        last_graph=graph;
        Frame;
    End
End