/*
    Port of the Persian Pattern program from Acorn Electron BASIC to
    Div language by Sephiroth.

    Original program can be found on page 34, chapter 8 of the Acorn Electron
    Users Manual.

    draw_line() function written by Peter.

*/

program persian;

GLOBAL
    d;
    k;
    j1;
    j2;
    i;
    col1;
    col2;

BEGIN
    set_mode(m800x600);
//    set_fps(200,4);
    d=4;
    j1=0;

    loop
        from k=500 to 380 step -40;

            REPEAT
                j2=rand(0,3);
            UNTIL(j2 <> j1);

            j1=j2;
            col1=rand(0,255);

            for (i=-k; i<=k; i=i+d);
                draw_line(k,i,-k,-i,col1);
                draw_line(i,-k,-i,k,col1);
                frame;
            end
        end
    //frame;
        clear_screen();
        frame;
    end
END





PROCESS draw_line(xp,yp,xq,yq,colour)

PRIVATE
    u=0;
    dx,dy,c,M,xinc=1,yinc=1;

BEGIN
    x=xp;
    y=yp;
    dx=xq-xp;
    dy=yq-yp;

    if(dx<0) xinc=-1; dx=-dx; end
    if(dy<0) yinc=-1; dy=-dy; end

    if(dy<dx)
        c=2*dx; M=2*dy;

        while(x!=xq)
            put_pixel(x,y,colour);
            x+=xinc; u+=M;

            if(u>dx) y+=yinc; u-=c; end
        end

    else

        c=2*dy; M=2*dx;

        while(y!=yq)
            put_pixel(x,y,colour);
            y+=yinc; u+=M;

            if(u>dy) x+=xinc; u-=c; end
        end
    end

    put_pixel(xq,yq,colour);

END

