
// M7 TUTORIAL
// VINIC GAMES vincent NICOLAS

PROGRAM M7TUT;

GLOBAL m7x;m7y;

BEGIN
    set_mode(m800x600);
    load_fpg("F:\div\m7tut\m7tut.fpg"); //attention! donnees locales!
                                        //careful! local datas!
    set_fps(30,0);

    start_mode7(0,0,001,002,0,200); //graph 001> graph mode7
                                    //graph 002> graph exterieur/external graph
                                    //m7.horizon=200;
                                    //note: 001 == 1
                                    //
//!!! le graphisme exterieur (002) doit avoir ses cotes=2,4,8,16,32 ou 64, etc
//!!! external graph must have sides=2,4,8,16,32 ou 64, etc

    m7.color=50;    //definit la couleur exterieure au graphisme du mode7
                    //dans ce cas, on ne la voit pas car elle est couverte
                    //par le graphisme exterieur definit dans le start_mode7()
                    //remplacer le 002 par 000 pour voir cette couleur.
                    //
                    //defines external color to mode7 graph.
                    //in that case, you can't see it because it is covered
                    //by the external graph set in start_mode7()
                    //replace 002 by 000 to make it appear.

    m7.camera=id;   //indispensable! definit le processus lui-meme(id) comme
                    //le processus suivi par la camera.
                    //don't forget! defines process itself(id) as the one
                    //followed by camera.

    m7.height=300;
    m7.distance=300;
    angle=90000;
    x=128;y=128;
    //juste pour donner des valeurs au depart.
    //just to give starting values.

    point();

    LOOP
        IF (key(_left))     x-=1; END
        IF (key(_right))    x+=1; END
        IF (key(_up))       y-=1; END
        IF (key(_down))     y+=1 ; END
        IF (key(_x))        angle-=1000; END
        IF (key(_v))        angle+=1000; END
        IF (key(_f))        m7.height+=10; END
        IF (key(_c))        m7.height-=10; END
        IF (key(_h))        m7.distance-=10; END
        IF (key(_b))        m7.distance+=10; END
        IF (key(_j))        m7.horizon+=1; END
        IF (key(_n))        m7.horizon-=1; END
        IF (key(_pgup))     m7.focus+=1; END
        IF (key(_pgdn))     m7.focus-=1; END

        delete_text(all_text);

        write(0,200,10,2,"x (cursor)=");
        write_int(0,210,10,0,OFFSET x);

        write(0,200,30,2,"y (cursor)=");
        write_int(0,210,30,0,OFFSET y);

        write(0,200,50,2,"angle (x,v)=");
        write_int(0,210,50,0,OFFSET angle);

        write(0,200,70,2,"height (f,c)=");
        write_int(0,210,70,0,OFFSET m7.height);

        write(0,200,90,2,"distance (h,b)=");
        write_int(0,210,90,0,OFFSET m7.distance);

        write(0,200,110,2,"horizon (j,n)=");
        write_int(0,210,110,0,OFFSET m7.horizon);

        write(0,200,130,2,"focus (pgup,pgdn)=");
        write_int(0,210,130,0,OFFSET m7.focus);

        write(0,500,10,1,"(r)= reset all values");
        write(0,500,70,1,"!!! azerty keyboard !!!");

        m7x=x;  //permet de renvoyer les valeurs de x et y au pointeur.
        m7y=y;  //allows to send x and y data to pointer.

        IF (key(_r))
            x=128;
            y=128;
            angle=90000;
            m7.height=300;
            m7.distance=300;
            m7.horizon=200;
            m7.focus=256;
        END

        IF (key(_esc)) exit("merci - thanks",0); END


        FRAME;
    END
END


PROCESS point()
BEGIN
    graph=3;
    ctype=c_m7; //place ce processus dans le plan mode7
                //put the process in mode7 plane

    LOOP
        x=m7x;
        y=m7y;
        FRAME;
    END
END

//!!! les graphiques places dans le mode7 apparaissent toujours de face!
//!!! graphs placed in mode7 are always shown face!
