//----------------------------------------------------------------------
// Program:  Stones
// Author:   Angelo Enea -AES-
// Date:     21/05/2002
//----------------------------------------------------------------------

PROGRAM PGM_Stones;

CONST
   _NUM_RIG_MAX = 14;  // numero massimo di righe partendo da 0
   _NUM_COL_MAX = 09;  // numero massimo di colonne partendo da 0
   _NUM_LEVEL   = 02;  // numero massimo di livelli partendo 0
   _STONE_SIDE  = 20;  // lato in pixel del grafico
   _NUM_COLORI  = 04;  // numero colori partendo da 0
   _DX_CHAR     = 16;  // intercarattere in pixel
   _NUM_CHAR    = 21;  // numero di caratteri per il record partendo da 0

GLOBAL
   STRUCT griglia
      STRUCT  riga [_NUM_RIG_MAX]
         STRUCT  colonna [_NUM_COL_MAX]
            x; y; occupato; // graph dei mattoncini oppure 0
            condannato;
         END;
      END;
   END =  150 DUP (0,0,0);

   STRUCT tab_level[_NUM_LEVEL]
      num_row;
      num_col;
   END=(04,03),(09,06),(14,09);

                  // coincidono con i grafici dei mattoncini
   cod_colore[] = 1  // giallo
                , 2  // rosso
                , 3  // viola
                , 4  // verde
                , 5; // blu

   scroll_map[] = "Stones\Mappa01.map" ,
                  "Stones\Mappa02.map" ,
                  "Stones\Mappa03.map" ;

   tab_music[]  = "Stones\Musica01.pcm" ,
                  "Stones\Musica02.pcm" ;
   ind_tab_music=1; // indice usato in modo alternato 0/1 partendo da 0

   // struttura salvataggio dati record
   STRUCT store
      record_name[21];
      record_score;
   END;

   level;
   num_rig;
   num_col;

   // variabili di punteggio
   punteggio_tot; // punteggio totale partita
   punteggio_liv; // punteggio di livello

   record_superato=0;
   file_oggetti;
   continua;
   nuovo_livello;
   nuovo_gioco;
   stones_fnt;
   mattoncini;
   id_slide_w;
   id_metal_slide_w;
   apertura=-1;
   chiusura=+1;

   esplosione_pcm;
   stone_pcm;
   button_pcm;
   sirena_pcm;
   dlin_pcm;
   open_pcm;
   close_pcm;
   intro_i_pcm;
   intro_f_pcm;
   op_alias_pcm;
   cl_alias_pcm;
   record_pcm;
   sfondo_pcm;
   sfondo_pcm_chnl; // canale di sfondo_pcm

LOCAL
   stato;

//============================= MAIN
PRIVATE
   scroll_texture;

BEGIN
   set_fps(32,0);

// inizializza la struttura. si usa scroll_texture per non crearne un'altra
   FROM scroll_texture=0 TO _NUM_CHAR;
      store.record_name[scroll_texture] = -1;
   END;
   store.record_score      =0;

   text_z = -100;

       //----------RESET RECORD_NAME
   load("Stones\Record.dat", &store);
   IF (store.record_score<0)  // per eventuali dati spuri
      store.record_score=0;
   END;
   IF (store.record_score==0) // resetta il record_name
      FROM scroll_texture=0 TO _NUM_CHAR;
         store.record_name[scroll_texture] = -1;
      END;
      store.record_name[00] = '<';
      store.record_name[01] = ' ';
      store.record_name[02] = 'E';
      store.record_name[03] = ' ';
      store.record_name[04] = 'M';
      store.record_name[05] = ' ';
      store.record_name[06] = 'P';
      store.record_name[07] = ' ';
      store.record_name[08] = 'T';
      store.record_name[09] = ' ';
      store.record_name[10] = 'Y';
      store.record_name[11] = ' ';
      store.record_name[12] = '>';
   END;

   file_oggetti   = load_fpg ("Stones\Stones.fpg"     );
   stones_fnt     = load_fnt ("Stones\Stones.fnt"     );
   esplosione_pcm = load_pcm ("Stones\Esplosio.pcm" ,0);
   stone_pcm      = load_pcm ("Stones\Stone.pcm"    ,0);
   button_pcm     = load_pcm ("Stones\Button.pcm"   ,0);
   sirena_pcm     = load_pcm ("Stones\Sirena.pcm"   ,0);
   dlin_pcm       = load_pcm ("Stones\Dlin.pcm"     ,0);
   open_pcm       = load_pcm ("Stones\Open.pcm"     ,0);
   close_pcm      = load_pcm ("Stones\Close.pcm"    ,0);
   intro_i_pcm    = load_pcm ("Stones\Intro_i.pcm"  ,0);
   intro_f_pcm    = load_pcm ("Stones\Intro_f.pcm"  ,0);
   op_alias_pcm   = load_pcm ("Stones\Op_Alias.pcm" ,0);
   cl_alias_pcm   = load_pcm ("Stones\Cl_Alias.pcm" ,0);
   record_pcm     = load_pcm ("Stones\Record.pcm"   ,0);

   set_mode(m800x600);
   continua = 0;
   intro(1); // 1 per intro iniziale
   REPEAT
      FRAME;
   UNTIL (continua);
   let_me_alone();
   mouse.file  = file_oggetti;
   mouse.graph = 999;
   continua    = 0;
   level=0;

   REPEAT               // ciclo di vita
      nuovo_livello = 0;
           // attiva il livello corrente
      IF (    level > -1
          AND level <= _NUM_LEVEL)
         num_rig=tab_level[level].num_row;
         num_col=tab_level[level].num_col;
      ELSE
         IF (level < 0)
            level = 0;
         ELSE
            level = _NUM_LEVEL;
         END;
      END;

      REPEAT            // ciclo di gioco
         scroll_texture = load_map(scroll_map[level]);
         start_scroll(0,0,scroll_texture,0,0,+1);

         board();           // valorizza nuovo_livello per ricominciare
         fade_on();
         WHILE (fading)
            scroll.x0 += 5;
            FRAME;
         END;

         REPEAT
            scroll.x0 += 5;
            FRAME;
         UNTIL (nuovo_livello OR continua);

      UNTIL (nuovo_livello OR continua);

      fade_off();
      WHILE (fading)
         scroll.x0 += 5;
         FRAME;
      END;
      delete_text(all_text);
      stop_scroll(0);
      unload_map(scroll_texture);
      let_me_alone();
   UNTIL (continua);

   fade_off();
   WHILE (fading) FRAME; END;
   let_me_alone();
   mouse.graph = 0;

   continua = 0;
   intro(0); // 0 per intro finale
   REPEAT
      FRAME;
   UNTIL (continua);

   EXIT("AES Entertainment ;)",0);
END; // MAIN

//============================= INTRO

PROCESS intro(modo);
PRIVATE
   sfondo_intro=9;
   angolar_speed=+5000;
   ray=100; grafico=20;
   angolo_scroll;
   xi; yi; xf; yf;
BEGIN
   file=file_oggetti;
   graph=grafico;
   z=0; x=400; y=388;

       // area per l'arresto dei mattoncini
   get_real_point(1, &xi, &yi);
   get_real_point(2, &xf, &yf);

   start_scroll(0,file_oggetti,sfondo_intro,0,0,3);

   fade_on();
   WHILE (fading)
      angolo_scroll+=angolar_speed;
      scroll.x0 = get_distx(angolo_scroll,ray);
      scroll.y0 = get_disty(angolo_scroll,ray);

      block_intro(xi, yi, xf, yf);
      FRAME;
   END;

    // continua a generare i mattoncini
   timer=0;

   REPEAT
      angolo_scroll+=angolar_speed;
      scroll.x0 = get_distx(angolo_scroll,ray);
      scroll.y0 = get_disty(angolo_scroll,ray);

      block_intro(xi, yi, xf, yf);
      FRAME;
   UNTIL (timer>300 OR mouse.left OR mouse.right OR scan_code != 0);


    // intro iniziale o finale
   IF (timer > 300)
      stones_intro(modo);


      // se intro iniziale, termina dopo 10 secondi
      // se itro finale, termina dopo 4 secondi (parte gia' a 6 secondi)
      IF (modo)
         timer=0;
      ELSE
         timer=600;
      END;

      REPEAT
         angolo_scroll+=angolar_speed;
         scroll.x0 = get_distx(angolo_scroll,ray);
         scroll.y0 = get_disty(angolo_scroll,ray);
         FRAME;
      UNTIL (mouse.left OR mouse.right OR scan_code != 0 OR timer>1000);
      // segnala la cessazione del suono
      get_id(type stones_intro).stato=1;
   END;



   fade_off();
   WHILE (fading)
      angolo_scroll+=angolar_speed;
      scroll.x0 = get_distx(angolo_scroll,ray);
      scroll.y0 = get_disty(angolo_scroll,ray);
      FRAME;
   END;

   stop_scroll(0);

   continua = 1;

END; // INTRO

//============================= BLOCK_INTRO

PROCESS block_intro(xi, yi, xf, yf);
PRIVATE
   caduta=+40;
   ground;

BEGIN
   file = file_oggetti; z = -3;
   graph = cod_colore[rand(0, _NUM_COLORI - 2 +level)];

   x      = rand(xi, xf   );
   size   = rand(90, 130  );
   angle  = rand(0 , 2*PI );
   ground = rand(yi, yf   );

   FOR (y=-20; y<ground AND NOT collision(father) ; y+=caduta)
      FRAME;
   END;

   sound(dlin_pcm,100,400);

   LOOP
      FRAME;
   END;

END;  // BLOCK_INTRO

//============================= STONES_INTRO

PROCESS stones_intro(modo);
PRIVATE
   grafico=21; i; xpc; ypc;
   id_T_intro; id_E_intro;
   inizio=1; fine=0; sound_channel;
BEGIN
   file=file_oggetti;
   graph=grafico;
   x=399; z=-1; size=150;

   get_real_point(1, &xpc, &ypc);
   id_T_intro = T_intro(xpc,ypc);

   get_real_point(2, &xpc, &ypc);
   id_E_intro = E_intro(xpc,ypc);

   FROM y=-100 TO 350 STEP(+40);
      FRAME;
   END;

   FROM i=1 TO 10;
      esplosione_intro( rand((x-300),(x+300)), rand((y-50),(y+50)));
      FRAME;
   END;

   sound_channel=sound(intro_i_pcm,256,256);

                        // ANIMAZIONE INTRO INZIALE
   IF (modo == inizio)
      // attiva animazione frammento 'E'
      timer=0;
      REPEAT
         IF (id.stato) //--- skip intro
            stop_sound(sound_channel);
         END;
         FRAME;
      UNTIL (timer>400);
      id_E_intro.stato = 1;

      // attiva animazione lettera 'T'
      timer=0;
      REPEAT
         FRAME;
      UNTIL (timer>300);
      id_T_intro.stato = 1;
   END;

                        // ANIMAZIONE INTRO FINALE
   IF (modo == fine)
      timer=0;
      REPEAT
         FRAME;
      UNTIL (timer>300);
      bye_intro();
   END;

   LOOP
      FRAME;
   END;

END;  // STONES_INTRO

//============================= T_INTRO

PROCESS T_intro(x, y);
PRIVATE
   delta_x; delta_y;
   grafico=26;
   caduta    = +20;
   rotazione = -7000;

BEGIN
   file    = father.file;
   graph   = grafico;
   size    = father.size;
   z       = father.z - 2;
   delta_x = father.x - x;
   delta_y = father.y - y;

   REPEAT
      x = father.x - delta_x;
      y = father.y - delta_y;
      FRAME;
   UNTIL (id.stato == 1);

// prima animazione: caduta

   REPEAT
      y     += caduta;
      FRAME;
   UNTIL (y > father.y + 20);

   esplosione_intro(x, y);
   FRAME;

// seconda animazione: rotazione

   REPEAT
      angle += rotazione;
      IF (angle < -PI/2)
         angle = -PI/2;
      END;
      FRAME;
   UNTIL (angle == -PI/2);

   esplosione_intro(x+200, y);

   LOOP
      FRAME;
   END;

END; // T_INTRO

//============================= E_INTRO

PROCESS E_intro(x, y);
PRIVATE
   delta_x; delta_y;
   grafico=27;
   caduta    = +20;

BEGIN
   file    = father.file;
   graph   = grafico;
   size    = father.size;
   z       = father.z - 3;
   delta_x = father.x - x;
   delta_y = father.y - y;

   REPEAT
      x = father.x - delta_x;
      y = father.y - delta_y;
      FRAME;
   UNTIL (id.stato == 1);

// animazione

   REPEAT
      y     += caduta;
      FRAME;
   UNTIL (y > father.y + 20);

   esplosione_intro(x, y);
   FRAME;
   esplosione_intro(x+50, y);

   LOOP
      FRAME;
   END;

END; // E_INTRO

//============================= BYE_INTRO

PROCESS bye_intro();
PRIVATE
   grafico=  28;
   caduta = +40;
   yl     = 222;
   yf     = 350;
BEGIN
   file  = file_oggetti;
   z     = father.z - 1;
   size  = father.size;
   x     = father.x;
   y     = -100;
   graph = grafico;

   sound(intro_f_pcm,256,256);

   REPEAT
      y += caduta;
      IF (y > 222)
         y = 222;
      END;
      FRAME;
   UNTIL (y == 222);

   sound(dlin_pcm,256,256);

   REPEAT
      y        += caduta;
      father.y += caduta;
      IF (y > yf)
         father.y -= y - yf;
         y = yf;
      END;
      FRAME;
   UNTIL (y == yf);

   FROM yf=1 TO 5;
      esplosione_intro( rand((x-150),(x+150)), rand((y-50),(y+50)));
      FRAME;
   END;

   LOOP
      FRAME;
   END;

END; // BYE_INTRO

//============================= ESPLOSIONE_INTRO

PROCESS esplosione_intro(x, y);
PRIVATE
   grafico[]= 22, 23, 24, 25;
   i;

BEGIN
   file=file_oggetti;
   z=-4; size=500;
   sound(esplosione_pcm,256,256);
   FROM i=0 TO 3;
      graph=grafico[i];
      FRAME;
   END;

END; // ESPLOSIONE_INTRO

//============================= BOARD

PROCESS board();
PRIVATE
   grafico = 8; y_locato = 299;
   xpc; ypc; r; c; vel_caduta = 50;
   premuto; premuto_reset;
   punteggio_liv_old; id_stone;
   id_new_game_button; i;
   id_reset_game_button;
   id_exit_button; id_arbitro;
   tab_txt_name[_NUM_CHAR];
   txt_score; volume; volume_old;
   premuto_music; premuto_decr;
BEGIN
   file = file_oggetti;
   x = 399; y = -100; z = 0;
   graph = grafico; id.stato=0;

   // carica alternativamente gli sfondi musicali
   ind_tab_music  = ind_tab_music XOR 1;
   sfondo_pcm     = load_pcm (tab_music[ind_tab_music] ,1);
   volume=0;
   sfondo_pcm_chnl=sound(sfondo_pcm,volume,256);

                   // ---- SLIDE_W: SOLO PER LA DISCESA
   define_region(1,0,0,800,600);
   get_real_point(10,&xpc, &ypc);
   id_slide_w       = metal_slide_w(xpc, ypc);
   id_metal_slide_w = slide_w      (xpc, ypc);

   FOR (y=-100; y<=y_locato; y+=vel_caduta)

      IF (volume<=256)
         volume+=10;
         change_sound(sfondo_pcm_chnl,volume,256);
      END;

      FRAME;
   END;
   y=y_locato;
   signal(id_slide_w      , s_kill_tree);
   signal(id_metal_slide_w, s_kill_tree);

                   // carica il primo punto della griglia
   get_real_point(1+level,&xpc, &ypc);

                   // carica la griglia con le coordinate
   FROM r = 0 TO _NUM_RIG_MAX;
      FROM c = 0 TO _NUM_COL_MAX;
         griglia.riga[r].colonna[c].x = xpc + (c * _STONE_SIDE);
         griglia.riga[r].colonna[c].y = ypc + (r * _STONE_SIDE);
         griglia.riga[r].colonna[c].occupato   = 0;
         griglia.riga[r].colonna[c].condannato = 0;
      END;
   END;
                   // ---- STONE COUNTER
   get_real_point( 4,&xpc, &ypc);
   mattoncini = 0;
   write_int(stones_fnt,xpc,ypc,4, &mattoncini);

                   // ---- PUNTEGGIO_LIV
   get_real_point( 5,&xpc, &ypc);
   write_int(stones_fnt,xpc,ypc,4, &punteggio_liv);

                   // ---- PUNTEGGIO_TOT
   get_real_point(11,&xpc, &ypc);
   write_int(stones_fnt,xpc,ypc,4, &punteggio_tot);

                   // ---- INFO RECORD
   get_real_point(12,&xpc, &ypc);
   FROM i=0 TO _NUM_CHAR;
      tab_txt_name[i]=-1;
   END;
                   // --------------- RECORD.NAME
   i=0;
   WHILE (i<=_NUM_CHAR)
      IF (store.record_name[i]==-1)
         i=_NUM_CHAR+1;
      ELSE
         xpc+=_DX_CHAR;
         tab_txt_name[i]=write(stones_fnt,xpc,ypc,4,store.record_name[i]);
      END;
      ++i;
   END;
                   // --------------- RECORD SCORE
   xpc+=_DX_CHAR * 3;
   txt_score=write_int(stones_fnt,xpc,ypc,3,&store.record_score);

                   // ---- EXIT BUTTON
   get_real_point( 6,&xpc, &ypc);
   id_exit_button = exit_button(xpc, ypc);

                   // ---- NEW GAME BUTTON
   get_real_point( 7,&xpc, &ypc);
   id_new_game_button = new_game_button(xpc, ypc);

                   // ---- RESET GAME BUTTON
   get_real_point(14,&xpc, &ypc);
   id_reset_game_button = reset_game_button(xpc, ypc);

                   // ---- REGION 1 (SLIDING DOORS)
   get_real_point( 8,&xpc, &ypc);
   get_real_point( 9,&r  , &c);
   define_region(1,xpc,ypc,r-xpc+1,c-ypc+1);

                   // ---- METAL_SLIDE_W
   get_real_point(10,&xpc, &ypc);
   id_metal_slide_w = metal_slide_w(xpc, ypc);

                   // ---- SLIDE_W
   get_real_point(10,&xpc, &ypc);
   id_slide_w = slide_w(xpc, ypc);

                   // ---- LED ARBITRO
   get_real_point(13,&xpc, &ypc);
   id_arbitro = arbitro(xpc, ypc);
   signal(id_arbitro, s_sleep);

   id_metal_slide_w.stato = apertura;
   REPEAT
      IF (volume<=256)
         volume+=10;
         change_sound(sfondo_pcm_chnl,volume,256);
      END;
      FRAME;
   UNTIL (id_metal_slide_w.stato == 0);

   REPEAT              //------ CICLO DI GIOCO
      nuovo_gioco = 0;
      mattoncini  = 0;
      punteggio_liv = 0;
      signal(id_new_game_button  , s_freeze);
      signal(id_reset_game_button, s_freeze);
      signal(id_exit_button      , s_freeze);

      id_slide_w.stato = apertura;
      REPEAT FRAME; UNTIL (id_slide_w.stato == 0);

        // genera i mattoncini partendo dal basso per l'animazione
      FOR (r=num_rig; r>=0; --r)
         FOR (c=0; c<=num_col; ++c)
            ++mattoncini;
            stone(r,c);
            sound(stone_pcm,75,256);

             // con questo ultimo ciclo setta il volume max
             // solo se non e' stata spenta la musica (volume=0)
            IF (volume>0 AND volume<=256)
               volume+=10;
               change_sound(sfondo_pcm_chnl,volume,256);
            END;

            FRAME (50);
         END;
      END;

      signal(id_new_game_button  , s_wakeup);
      signal(id_reset_game_button, s_wakeup);
      signal(id_exit_button      , s_wakeup);
      signal(id_arbitro          , s_wakeup);

      REPEAT         //----------- CICLO DI VITA
   //----------------------------------------SWITCH MUSIC
         IF (key(_M))
            IF (NOT premuto_music)
               premuto_music = 1;

               IF (volume > 0)
                  volume_old = volume;
                  volume     = 0;
               ELSE
                  volume = volume_old;
               END;
               change_sound(sfondo_pcm_chnl,volume,256);

            END;
         ELSE
            premuto_music = 0;
         END;

         FRAME;

      UNTIL(nuovo_gioco OR id.stato>0);

      signal(get_id(type arbitro), s_freeze);

      id_slide_w.stato = chiusura;
      REPEAT FRAME; UNTIL (id_slide_w.stato == 0);

      WHILE (id_stone = get_id(type stone))
         signal(id_stone, s_kill);
      END;
                   // resetta la griglia
      FROM r = 0 TO _NUM_RIG_MAX;
         FROM c = 0 TO _NUM_COL_MAX;
            griglia.riga[r].colonna[c].occupato   = 0;
            griglia.riga[r].colonna[c].condannato = 0;
         END;
      END;

   UNTIL (id.stato > 0);

//-------------------------- VITTORIA
   IF (id.stato == 1)
      // in caso di vittoria congela i pulsanti
      signal(id_new_game_button  , s_freeze);
      signal(id_reset_game_button, s_freeze);
      signal(id_exit_button      , s_freeze);

//---------------- SCARICA IL PUNTEGGIO DI LIVELLO IN QUELLO TOTALE
      REPEAT
         IF (punteggio_liv > 0)
            sound(stone_pcm,75,256);
            --punteggio_liv;
            ++punteggio_tot;
         END;
         FRAME;
      UNTIL (scan_code != 0 OR mouse.left OR mouse.right);
      punteggio_tot += punteggio_liv;
      punteggio_liv = 0;

//--------------- GESTIONE RECORD
      IF (punteggio_tot > store.record_score)
         //------ SOLO LA PRIMA VOLTA CHIEDE L'ALIAS
         IF (NOT record_superato)
            record_superato=1;

            REPEAT
               volume-=10;
               IF (volume<0)
                  volume=0;
               END;
               change_sound(sfondo_pcm_chnl,volume,256);
               FRAME;
            UNTIL (volume==0);

            new_record();
            FRAME;
            accept_record_alias();
            FRAME; // attualizza i processi

            //---------------- CANCELLA IL VECCHIO ALIAS ED IL RECORD_SCORE
            get_real_point(12,&xpc, &ypc);
            i=0;
            WHILE (i<=_NUM_CHAR)
               IF (tab_txt_name[i]==-1)
                  i=_NUM_CHAR+1;
               ELSE
                  xpc+=_DX_CHAR;
               END;
               ++i;
            END;
            xpc+=_DX_CHAR * 3;
            delete_text(txt_score);
            esplosione_char(xpc,ypc);

            get_real_point(12,&xpc, &ypc);
            i=0;
            WHILE (i<=_NUM_CHAR)
               IF (tab_txt_name[i]==-1)
                  i=_NUM_CHAR+1;
               ELSE
                  xpc+=_DX_CHAR;
                  delete_text(tab_txt_name[i]);
                  tab_txt_name[i]=-1;
                  esplosione_char(xpc,ypc);
                  FRAME(200);
               END;
               ++i;
            END;
            // --------------- RISCRIVE L'ALIAS
            get_real_point(12,&xpc, &ypc);
            i=0;
            WHILE (i<=_NUM_CHAR)
               IF (store.record_name[i]==-1)
                  i=_NUM_CHAR+1;
               ELSE
                  xpc+=_DX_CHAR;
                  sound(stone_pcm,75,256);
                  tab_txt_name[i]=write(stones_fnt,xpc,ypc,4,store.record_name[i]);
                  FRAME;
               END;
               ++i;
            END;
            // --------------- RISCRIVE IL RECORD_SCORE
            xpc+=_DX_CHAR * 3;
            txt_score=write_int(stones_fnt,xpc,ypc,3,&store.record_score);

         END; // IF (NOT record_superato)

         //---------------- SCARICA IL PUNTEGGIO TOTALE NEL RECORD_SCORE
         REPEAT
            IF (punteggio_tot > store.record_score)
               sound(stone_pcm,75,256);
               ++store.record_score;
            END;
            FRAME;
         UNTIL (scan_code != 0 OR mouse.left OR mouse.right);
         store.record_score=punteggio_tot;
         save("Stones\Record.dat", &store, sizeof(store));
      END; // IF (punteggio_tot > store.record_score)

   END; // IF (id.stato == 1) // vittoria

   id_slide_w.stato = chiusura;
   REPEAT
      volume-=10;
      IF (volume<0)
         volume=0;
      END;
      change_sound(sfondo_pcm_chnl,volume,256);
      FRAME;
   UNTIL (id_slide_w.stato == 0);

   id_metal_slide_w.stato = chiusura;
   REPEAT
      volume-=10;
      IF (volume<0)
         volume=0;
      END;
      change_sound(sfondo_pcm_chnl,volume,256);
      FRAME;
   UNTIL (id_metal_slide_w.stato == 0);

   signal (id_exit_button       , s_kill);
   signal (id_new_game_button   , s_kill);
   signal (id_reset_game_button , s_kill);
   signal (id_arbitro           , s_kill);

   delete_text(all_text);
   define_region(1,0,0,800,600); // per gli slide durante l'ascesa
   FOR (y=y_locato; y>=-100; y-=vel_caduta)
      volume-=10;
      IF (volume<0)
         volume=0;
      END;
      change_sound(sfondo_pcm_chnl,volume,256);
      FRAME;
   END;

   signal(id_slide_w      , s_kill_tree);
   signal(id_metal_slide_w, s_kill_tree);

   stop_sound(sfondo_pcm_chnl);
   unload_pcm(sfondo_pcm);

   IF (id.stato==1)     //* VITTORIA *//
      nuovo_livello = 1;
   END;
   IF (id.stato==2)     //* EXIT     *//
      continua = 1;
   END;
   IF (id.stato==3)     //* RESET    *//
      nuovo_livello = 1; // si ricorda che level=0
   END;

END; // BOARD

//============================= ARBITRO

PROCESS arbitro(x, y);
PRIVATE
   grafico[] = 7, 18;
   sconfitta = 0; vittoria = 1;
   r; c; i; j;
   suonato_sconfitta=0;
   controllo; flag;
BEGIN
   file = file_oggetti;
   graph = 0; z=-1;

   REPEAT    // attende il posizionamento dei mattoncini
      FRAME;
   UNTIL (griglia.riga[0].colonna[num_col].occupato > 0);

   LOOP
         // SE NON CI SONO I MATTONCINI E' VITTORIA
      IF (mattoncini==0)
         graph=grafico[vittoria];
         sound(dlin_pcm,256,400);
         ++level;
         father.stato = 1;
         REPEAT FRAME; UNTIL (mattoncini > 0);
         graph = 0;
      END;

          // controlla se tutti i mattoncini sono a riposo (senza cadute)
      controllo = 1;
      FOR (r=0; r<=num_rig - 1; ++r)
         FOR (c=0; c<=num_col; ++c)
            IF (    griglia.riga[r]  .colonna[c].occupato    > 0
                AND griglia.riga[r+1].colonna[c].occupato == 0)
               controllo = 0;
            END;
         END;
      END;

            // controlla se il gioco e' finito
      IF (controllo)
         flag=+3;
         FOR (r=0; r<=num_rig; ++r)
            FOR (c=0; c<=num_col; ++c)
               IF (griglia.riga[r].colonna[c].occupato > 0)
                  flag=+2;
                  FOR (i=r-1; i<=r+1; ++i)
                     FOR (j=c-1; j<=c+1; ++j)
                   // controllo limiti, propria posizione e cardinalia'
                        IF (    i > -1 AND i < num_rig + 1
                            AND j > -1 AND j < num_col + 1
                            AND (i != r OR j != c)
                            AND (i == r OR j == c))
                           IF (    griglia.riga[i].colonna[j].occupato ==
                                   griglia.riga[r].colonna[c].occupato
                               AND griglia.riga[i].colonna[j].occupato >0);
                              flag=+1;
                              i=r+2; j=c+2;
                              r=num_rig+1;
                              c=num_col+1;
                           END;
                        END;
                     END;
                  END;
               END;
            END;
         END;
 // se flag=+3 significa che tutte le posizioni sono 0 e quindi e' possibile
 // che ci sia vittoria: capita, infatti, che l'arbitro controlli la variabile
 // mattoncini e sia > 0; poi, prima di passare al controllo di sopra, tutti i
 // restanti mattoncini esplodono azzerando le posizioni. In questo caso, al
 // controllo di sopra risulta tutte le posizioni nulle, nonostante il numero
 // dei mattoncini sia non nullo!!!!!
 // Questo non dovrebbe accadere, visto che tra il controllo del numero dei
 // mattoncini ed il controllo delle posizioni non c'e' alcuna sentenza FRAME:
 // accade, infatti, solo molto di rado!!!!!!!!!!!!!!!

         IF ((flag==+2 OR mattoncini==1) AND NOT suonato_sconfitta)
            suonato_sconfitta=1;
            graph=grafico[sconfitta];
            sound(sirena_pcm,256,256);
         ELSE
            IF (flag==+2 OR mattoncini==1)
               graph=grafico[sconfitta];
            ELSE
               graph=0;
               suonato_sconfitta=0;
            END;
         END;
      END;

      FRAME;
   END;

END; // ARBITRO

//============================= EXIT_BUTTON

PROCESS exit_button(x, y);
PRIVATE
   grafico = 6;
   normale = 0; premuto = PI;
BEGIN
   file = file_oggetti;
   graph = grafico; z=-1;

   LOOP
      IF (collision (type mouse) AND NOT mouse.left)
         WHILE (collision (type mouse) AND NOT mouse.left)
            FRAME;
         END;
         IF (collision (type mouse) AND mouse.left)
            sound(button_pcm,256,256);
            angle = premuto;
            WHILE (mouse.left) FRAME; END;
            save("Stones\Record.dat", &store, sizeof(store));
            angle = normale;
            father.stato = 2;
         END;
      END;
      FRAME;
   END;

END; // EXIT_BUTTON

//============================= NEW_GAME_BUTTON

PROCESS new_game_button(x, y);
PRIVATE
   grafico = 6;
   normale = 0;
   premuto = PI;
BEGIN
   file = file_oggetti;
   graph = grafico; z=-1;

   LOOP
      IF (collision (type mouse) AND NOT mouse.left)
         WHILE (collision (type mouse) AND NOT mouse.left)
            FRAME;
         END;
         IF (collision (type mouse) AND mouse.left)
            sound(button_pcm,256,256);
            angle = premuto;
            WHILE (mouse.left) FRAME; END;
            angle = normale;
            nuovo_gioco = 1;
         END;
      END;

      FRAME;
   END;

END; // NEW_GAME_BUTTON

//============================= RESET_GAME_BUTTON

PROCESS reset_game_button(x, y);
PRIVATE
   grafico = 6; i;
   normale = 0;
   premuto = PI;
BEGIN
   file = file_oggetti;
   graph = grafico; z=-1;

   LOOP
      IF (collision (type mouse) AND NOT mouse.left)
         WHILE (collision (type mouse) AND NOT mouse.left)
            FRAME;
         END;
         IF (collision (type mouse) AND mouse.left)
            sound(button_pcm,256,256);
            angle = premuto;
            WHILE (mouse.left) FRAME; END;
            angle = normale;

            // inizializza la struttura
            FROM i=0 TO _NUM_CHAR;
               store.record_name[i] = -1;
            END;
            store.record_name[00] = '<';
            store.record_name[01] = ' ';
            store.record_name[02] = 'E';
            store.record_name[03] = ' ';
            store.record_name[04] = 'M';
            store.record_name[05] = ' ';
            store.record_name[06] = 'P';
            store.record_name[07] = ' ';
            store.record_name[08] = 'T';
            store.record_name[09] = ' ';
            store.record_name[10] = 'Y';
            store.record_name[11] = ' ';
            store.record_name[12] = '>';

            store.record_score =0;
            punteggio_tot =0;
            level=0; // il salvataggio avverr in main
            father.stato = 3;
         END;
      END;

      FRAME;
   END;

END; // RESET_GAME_BUTTON

//============================= SLIDE_W

PROCESS slide_w(x,y);
PRIVATE
   slide_speed=5;
   grafico = 19;
   x_confine; xi;
   in_moto; delta_y;
   suonato; suono;
BEGIN
   file=file_oggetti;
   graph=grafico;
   region=1;
   z=-2;
   xi=x;
   delta_y=father.y - y;
   slide_e();
   x_confine=griglia.riga[0].colonna[0].x - (_STONE_SIDE/2) -1;

   LOOP
      in_moto = 0;

// --------- OPEN
      IF (id.stato == -1 AND x > x_confine)
         in_moto=1;
         IF (NOT suonato)
            suonato=1;
            suono=sound(open_pcm,256,256);
         END;
         x-=slide_speed;
         IF(x < x_confine)
            x = x_confine;
         END;
      END;

// --------- CLOSE
      IF (id.stato == +1 AND x < xi)
         in_moto=1;
         IF (NOT suonato)
            suonato=1;
            suono=sound(close_pcm,256,256);
         END;
         x+=slide_speed;
         IF(x > xi)
            x = xi;
         END;
      END;

      IF (NOT in_moto)
         id.stato=0;
         IF (suonato)
            suonato = 0;
            stop_sound(suono);
         END;
      END;

      y = father.y - delta_y; // utile nella discesa o ascesa
      FRAME;
   END;

END; // SLIDE_W

//============================= SLIDE_E

PROCESS slide_e();
PRIVATE
   xi; yi;
BEGIN
   file=father.file;
   x=father.x;
   y=father.y;
   z=father.z;
   region=father.region;
   graph=father.graph;
   flags=1;
   xi=x; yi=y;

   LOOP
      x=(2*xi)-father.x+1;
      y=father.y;  // utile nella discesa o ascesa
      FRAME;
   END;

END; // SLIDE_E

//============================= METAL_SLIDE_W

PROCESS metal_slide_w(x,y);
PRIVATE
   slide_speed=5;
   grafico = 17;
   x_confine; xi;
   in_moto; delta_y;
   suonato; suono;
BEGIN
   file=file_oggetti;
   graph=grafico;
   region=1;
   z=-3;
   xi=x;
   delta_y=father.y - y;
   metal_slide_e();
   x_confine=griglia.riga[0].colonna[0].x - (_STONE_SIDE/2) -1;

   LOOP
      in_moto = 0;

// --------- OPEN
      IF (id.stato == -1 AND x > x_confine)
         in_moto=1;
         IF (NOT suonato)
            suonato=1;
            suono=sound(open_pcm,256,256);
         END;
         x-=slide_speed;
         IF(x < x_confine)
            x = x_confine;
         END;
      END;

// --------- CLOSE
      IF (id.stato == +1 AND x < xi)
         in_moto=1;
         IF (NOT suonato)
            suonato=1;
            suono=sound(close_pcm,256,256);
         END;
         x+=slide_speed;
         IF(x > xi)
            x = xi;
         END;
      END;

      IF (NOT in_moto)
         id.stato=0;
         IF (suonato)
            suonato = 0;
            stop_sound(suono);
         END;
      END;

      y = father.y - delta_y; // utile nella discesa o ascesa
      FRAME;
   END;

END; // METAL_SLIDE_W

//============================= METAL_SLIDE_E

PROCESS metal_slide_e();
PRIVATE
   xi; yi;
BEGIN
   file=father.file;
   x=father.x;
   y=father.y;
   z=father.z;
   region=father.region;
   graph=father.graph;
   flags=1;
   xi=x; yi=y;

   LOOP
      x=(2*xi)-father.x+1;
      y=father.y;  // utile nella discesa o ascesa
      FRAME;
   END;

END; // METAL_SLIDE_E

//============================= STONE

PROCESS stone(r,c);
PRIVATE
   esplosione[] = 10,11,12,13,14,15;
   num_espl = 5; id_stone; riposo;
   giustiziato; i; j; vel_caduta = 100;
BEGIN
   priority=1;
   file = file_oggetti; z = -1;
   graph = cod_colore[rand(0, _NUM_COLORI - 2 +level)];

                       //---------------CADUTA
   x = griglia.riga[r].colonna[c].x;

   FOR (y=+10; y<=griglia.riga[r].colonna[c].y; y+=vel_caduta)
      FRAME;
   END;

   y = griglia.riga[r].colonna[c].y;
   griglia.riga[r].colonna[c].occupato = graph;

   // attende il posizionamento dell'ultimo mattoncino
   REPEAT FRAME; UNTIL(griglia.riga[0].colonna[num_col].occupato > 0)

   REPEAT
   //--------------------------ACCUSATO E CONDANNATO   //
      IF (griglia.riga[r].colonna[c].condannato == 0)
         IF (collision (type mouse) AND mouse.left)
    // solo se tutti i mattoncini sono posizionati procede
    // con l'indagine per la condanna in primo appello
            riposo=1;
            FOR (i=0; i<num_rig; ++i)
               FOR (j=0; j<num_col; ++j)
                  IF (    griglia.riga[i]  .colonna[j].occupato > 0
                      AND griglia.riga[i+1].colonna[j].occupato ==0)
                     riposo=0;
                  END;
               END;
            END;

            IF (riposo)
               FOR (i=r-1; i<=r+1; ++i)
                  FOR (j=c-1; j<=c+1; ++j)
                // controllo limiti, propria posizione e cardinalia'
                     IF (    i > -1 AND i < num_rig + 1
                         AND j > -1 AND j < num_col + 1
                         AND (i != r OR j != c)
                         AND (i == r OR j == c))
                        IF (griglia.riga[i].colonna[j].occupato == graph)
                           griglia.riga[r].colonna[c].condannato = 1;
                           angle = PI;
                           sound(stone_pcm,170,256);
                        // invoca il giudice per le indagini e le condanne
                           giudice();
                           i=r+2; j=c+2;
                        END;
                     END;
                  END;
               END;
            END; // IF (riposo)

         END; // IF (collision (type mouse) AND mouse.left)
      END; // IF (griglia.riga[r].colonna[c].condannato == 0)

   //--------------------------CONDANNATO   //
      IF (griglia.riga[r].colonna[c].condannato == 1)
         angle = PI;
         sound(stone_pcm,170,256);
      END;

   //--------------------------ASSOLTO      //
      IF (griglia.riga[r].colonna[c].condannato == 0)
         angle = 0;
      END;

   //--------------------------GIUSTIZIATO  //
      IF (griglia.riga[r].colonna[c].condannato == 2)
         FROM i=0 TO 5;
            graph = esplosione[i];
            FRAME;
         END;
         griglia.riga[r].colonna[c].occupato = 0;
         --mattoncini; giustiziato = 1;
      END;
   //--------------------------TRASFERITO  //
      IF (r < num_rig AND NOT giustiziato)
         IF (griglia.riga[r + 1].colonna[c].occupato == 0)
            griglia.riga[r].colonna[c].occupato   = 0;
            griglia.riga[r].colonna[c].condannato = 0;
            ++r;
            x = griglia.riga[r].colonna[c].x;
            y = griglia.riga[r].colonna[c].y;
            griglia.riga[r].colonna[c].occupato   = graph;
            griglia.riga[r].colonna[c].condannato = 0;
          END;
      END;

      FRAME;
   UNTIL (giustiziato);

END; // STONE

//============================= GIUDICE

PROCESS giudice();
PRIVATE
   condanna; mattoncini_condannati;
   r; c; i; j; punteggio_liv_old;
   punteggio_par;
BEGIN
   //---- GESTISCE LE CONDANNE DEI MATTONCINI

   // CICLA FINO A QUANDO O NON CI SONO CONDANNE         (condanna=0)
   // OPPURE SE TUTTI I MATTONCINI SONO STATI CONDANNATI (condanna=1)
   condanna = 0;
   mattoncini_condannati=1; // considera gia' il mattoncino selezionato
   // solo per l'estetica: inoltre punteggio_par cambia in base ai mattoncini
   punteggio_liv_old = punteggio_liv;
   REPEAT
      // se c'e' stato almeno una condanna nell'ultimo ciclo
      IF (condanna == -1)
         // alla iterazione successiva, se non ci sono piu' condanne
         // aggiuntive, condanna rimane a 1: per le giustizioni
         condanna = 1;
      END;

      FOR (r=0; r<=num_rig; ++r)
         FOR (c=0; c<=num_col; ++c)
            // se il mattoncino corrente e' condannato,
            // indaga i matoncini indiziati adiacenti.
            IF (griglia.riga[r].colonna[c].condannato == 1)
               FOR (i=r-1; i<=r+1; ++i)
                  FOR (j=c-1; j<=c+1; ++j)
                // controllo limiti, posizione e cardinalia'
                     IF (    i > -1 AND i <= num_rig
                         AND j > -1 AND j <= num_col
                         AND (i != r OR j != c)
                         AND (i == r OR j == c))
                    // si condanna l'indiziato
                        IF (    griglia.riga[i].colonna[j].occupato   >  0
                            AND griglia.riga[i].colonna[j].condannato == 0
                            AND griglia.riga[i].colonna[j].occupato   ==
                                griglia.riga[r].colonna[c].occupato)
                           griglia.riga[i].colonna[j].condannato = 1;
                           FRAME; // i mattoncini si aggiornano evidenziandosi
                        // segnala l'avvenuta condanna
                           condanna = -1;
                           ++mattoncini_condannati;
                           punteggio_par=   (mattoncini_condannati - 1)
                                          * mattoncini_condannati;
                           punteggio_liv = punteggio_liv_old + punteggio_par;
                        END;
                     END;
                  END;
               END;
            END;
         END;
      END;
   UNTIL (condanna > -1);

      // SE C'E' ALMENO UNA CONDANNA, GIUSTIZIA I MATTONCINI CONDANNATI
   IF (condanna)
      condanna = 0;
      FOR (r=0; r<=num_rig; ++r)
         FOR (c=0; c<=num_col; ++c)
            IF (griglia.riga[r].colonna[c].condannato == 1)
               griglia.riga[r].colonna[c].condannato = 2;
            END;
         END;
      END;
      sound(esplosione_pcm,256,256);

   END;

   RETURN;

END; // GIUDICE

//============================= ACCEPT_RECORD_ALIAS

PROCESS accept_record_alias();
PRIVATE
   grafico= 16; i;
   inserito; xpc; ypc;
   tab_txt_name[_NUM_CHAR];
   tasto_premuto; tasto_riconosciuto;
BEGIN
   file=file_oggetti;
   z=-4; graph=grafico;
   x=399; y=320;

   signal(father, s_freeze);

   FROM i=0 TO _NUM_CHAR;
      tab_txt_name     [i] = -1;
      store.record_name[i] = -1;
   END;

   sound(op_alias_pcm,256,256);

   FROM size=0 TO 200 STEP(50);
      FRAME;
   END;

   get_real_point(1,&xpc,&ypc);

   i=0;
   inserito=0;
   REPEAT
      IF (scan_code!=0)
         IF (NOT tasto_premuto)
            tasto_premuto=1;
            sound(stone_pcm,75,256);
            tasto_riconosciuto=0;

//------------------------------------------- RICONOSCIMENTO CODICE ASCII
            SWITCH (ascii)
            CASE  33:
               store.record_name[i]='!';
               tasto_riconosciuto=1;
            END
            CASE  34:
               store.record_name[i]='"';
               tasto_riconosciuto=1;
            END
            CASE  35:
               store.record_name[i]='#';
               tasto_riconosciuto=1;
            END
            CASE  36:
               store.record_name[i]='$';
               tasto_riconosciuto=1;
            END
            CASE  37:
               store.record_name[i]='%';
               tasto_riconosciuto=1;
            END
            CASE  38:
               store.record_name[i]='&';
               tasto_riconosciuto=1;
            END
            CASE  39:
               store.record_name[i]="'";
               tasto_riconosciuto=1;
            END
            CASE  40:
               store.record_name[i]='(';
               tasto_riconosciuto=1;
            END
            CASE  41:
               store.record_name[i]=':';
               tasto_riconosciuto=1;
            END
            CASE  42:
               store.record_name[i]='*';
               tasto_riconosciuto=1;
            END
            CASE  43:
               store.record_name[i]='+';
               tasto_riconosciuto=1;
            END
            CASE  44:
               store.record_name[i]=',';
               tasto_riconosciuto=1;
            END
            CASE  45:
               store.record_name[i]='-';
               tasto_riconosciuto=1;
            END
            CASE  46:
               store.record_name[i]='.';
               tasto_riconosciuto=1;
            END
            CASE  47:
               store.record_name[i]='/';
               tasto_riconosciuto=1;
            END
            CASE  48:
               store.record_name[i]='0';
               tasto_riconosciuto=1;
            END
            CASE  49:
               store.record_name[i]='1';
               tasto_riconosciuto=1;
            END
            CASE  50:
               store.record_name[i]='2';
               tasto_riconosciuto=1;
            END
            CASE  51:
               store.record_name[i]='3';
               tasto_riconosciuto=1;
            END
            CASE  52:
               store.record_name[i]='4';
               tasto_riconosciuto=1;
            END
            CASE  53:
               store.record_name[i]='5';
               tasto_riconosciuto=1;
            END
            CASE  54:
               store.record_name[i]='6';
               tasto_riconosciuto=1;
            END
            CASE  55:
               store.record_name[i]='7';
               tasto_riconosciuto=1;
            END
            CASE  56:
               store.record_name[i]='8';
               tasto_riconosciuto=1;
            END
            CASE  57:
               store.record_name[i]='9';
               tasto_riconosciuto=1;
            END
            CASE  58:
               store.record_name[i]=':';
               tasto_riconosciuto=1;
            END
            CASE  59:
               store.record_name[i]=';';
               tasto_riconosciuto=1;
            END
            CASE  60:
               store.record_name[i]='<';
               tasto_riconosciuto=1;
            END
            CASE  61:
               store.record_name[i]='=';
               tasto_riconosciuto=1;
            END
            CASE  62:
               store.record_name[i]='>';
               tasto_riconosciuto=1;
            END
            CASE  63:
               store.record_name[i]='?';
               tasto_riconosciuto=1;
            END
            CASE  64:
               store.record_name[i]='@';
               tasto_riconosciuto=1;
            END
            CASE  65:
               store.record_name[i]='A';
               tasto_riconosciuto=1;
            END
            CASE  66:
               store.record_name[i]='B';
               tasto_riconosciuto=1;
            END
            CASE  67:
               store.record_name[i]='C';
               tasto_riconosciuto=1;
            END
            CASE  68:
               store.record_name[i]='D';
               tasto_riconosciuto=1;
            END
            CASE  69:
               store.record_name[i]='E';
               tasto_riconosciuto=1;
            END
            CASE  70:
               store.record_name[i]='F';
               tasto_riconosciuto=1;
            END
            CASE  71:
               store.record_name[i]='G';
               tasto_riconosciuto=1;
            END
            CASE  72:
               store.record_name[i]='H';
               tasto_riconosciuto=1;
            END
            CASE  73:
               store.record_name[i]='I';
               tasto_riconosciuto=1;
            END
            CASE  74:
               store.record_name[i]='J';
               tasto_riconosciuto=1;
            END
            CASE  75:
               store.record_name[i]='K';
               tasto_riconosciuto=1;
            END
            CASE  76:
               store.record_name[i]='L';
               tasto_riconosciuto=1;
            END
            CASE  77:
               store.record_name[i]='M';
               tasto_riconosciuto=1;
            END
            CASE  78:
               store.record_name[i]='N';
               tasto_riconosciuto=1;
            END
            CASE  79:
               store.record_name[i]='O';
               tasto_riconosciuto=1;
            END
            CASE  80:
               store.record_name[i]='P';
               tasto_riconosciuto=1;
            END
            CASE  81:
               store.record_name[i]='Q';
               tasto_riconosciuto=1;
            END
            CASE  82:
               store.record_name[i]='R';
               tasto_riconosciuto=1;
            END
            CASE  83:
               store.record_name[i]='S';
               tasto_riconosciuto=1;
            END
            CASE  84:
               store.record_name[i]='T';
               tasto_riconosciuto=1;
            END
            CASE  85:
               store.record_name[i]='U';
               tasto_riconosciuto=1;
            END
            CASE  86:
               store.record_name[i]='V';
               tasto_riconosciuto=1;
            END
            CASE  87:
               store.record_name[i]='W';
               tasto_riconosciuto=1;
            END
            CASE  88:
               store.record_name[i]='X';
               tasto_riconosciuto=1;
            END
            CASE  89:
               store.record_name[i]='Y';
               tasto_riconosciuto=1;
            END
            CASE  90:
               store.record_name[i]='Z';
               tasto_riconosciuto=1;
            END
            CASE  97:
               store.record_name[i]='a';
               tasto_riconosciuto=1;
            END
            CASE  98:
               store.record_name[i]='b';
               tasto_riconosciuto=1;
            END
            CASE  99:
               store.record_name[i]='c';
               tasto_riconosciuto=1;
            END
            CASE 100:
               store.record_name[i]='d';
               tasto_riconosciuto=1;
            END
            CASE 101:
               store.record_name[i]='e';
               tasto_riconosciuto=1;
            END
            CASE 102:
               store.record_name[i]='f';
               tasto_riconosciuto=1;
            END
            CASE 103:
               store.record_name[i]='g';
               tasto_riconosciuto=1;
            END
            CASE 104:
               store.record_name[i]='h';
               tasto_riconosciuto=1;
            END
            CASE 105:
               store.record_name[i]='i';
               tasto_riconosciuto=1;
            END
            CASE 106:
               store.record_name[i]='j';
               tasto_riconosciuto=1;
            END
            CASE 107:
               store.record_name[i]='k';
               tasto_riconosciuto=1;
            END
            CASE 108:
               store.record_name[i]='l';
               tasto_riconosciuto=1;
            END
            CASE 109:
               store.record_name[i]='m';
               tasto_riconosciuto=1;
            END
            CASE 110:
               store.record_name[i]='n';
               tasto_riconosciuto=1;
            END
            CASE 111:
               store.record_name[i]='o';
               tasto_riconosciuto=1;
            END
            CASE 112:
               store.record_name[i]='p';
               tasto_riconosciuto=1;
            END
            CASE 113:
               store.record_name[i]='q';
               tasto_riconosciuto=1;
            END
            CASE 114:
               store.record_name[i]='r';
               tasto_riconosciuto=1;
            END
            CASE 115:
               store.record_name[i]='s';
               tasto_riconosciuto=1;
            END
            CASE 116:
               store.record_name[i]='t';
               tasto_riconosciuto=1;
            END
            CASE 117:
               store.record_name[i]='u';
               tasto_riconosciuto=1;
            END
            CASE 118:
               store.record_name[i]='v';
               tasto_riconosciuto=1;
            END
            CASE 119:
               store.record_name[i]='w';
               tasto_riconosciuto=1;
            END
            CASE 120:
               store.record_name[i]='x';
               tasto_riconosciuto=1;
            END
            CASE 121:
               store.record_name[i]='y';
               tasto_riconosciuto=1;
            END
            CASE 122:
               store.record_name[i]='z';
               tasto_riconosciuto=1;
            END

            END: // SWITCH (ascii)

//------------------------------------------- TASTI DI CONTROLLO
            IF (key(_space))
               store.record_name[i]=' ';
               tasto_riconosciuto=1;
            END;
            IF (key(_enter))
               inserito=1;
            END;

            IF (key(_backspace))
               IF (i==_NUM_CHAR AND tab_txt_name[i]>0)
                  delete_text(tab_txt_name[i]);
                  tab_txt_name[i]=-1;
                  esplosione_char(xpc,ypc);
                  store.record_name[i]=-1;
               ELSE
                  IF (i>0)
                     --i;
                     xpc-=_DX_CHAR;
                  END;
                  IF (tab_txt_name[i]>0)
                     delete_text(tab_txt_name[i]);
                     tab_txt_name[i]=-1;
                     esplosione_char(xpc,ypc);
                  END;
                  IF (store.record_name[i]>-1)
                     store.record_name[i]=-1;
                  END;
               END;

            ELSE // IF (key(_backspace))
//----- AGGIORNA I TESTI
               IF (tasto_riconosciuto)
                  IF (i==_NUM_CHAR AND tab_txt_name[i]>0)
                     delete_text(tab_txt_name[i]);
                  END;
                  tab_txt_name[i]=write(stones_fnt,xpc,ypc,4,store.record_name[i]);
                  IF (i<_NUM_CHAR)
                     ++i;
                     xpc+=_DX_CHAR;
                  END;
               END;
            END; // IF (key(_backspace))
         END; // IF (NOT tasto_premuto)
      ELSE
         tasto_premuto=0;
      END; // IF (scan_code!=0)

      FRAME;
   UNTIL (inserito);

   FROM i=0 TO _NUM_CHAR;
      IF (tab_txt_name[i] > 0)
         delete_text(tab_txt_name[i]);
      END;
   END;

   sound(cl_alias_pcm,256,256);

   FROM size=200 TO 0 STEP(-50);
      FRAME;
   END;

   signal(father, s_wakeup);

END; // ACCEPT_RECORD_ALIAS

//============================= NEW_RECORD

PROCESS new_record();
PRIVATE
   grafico=29; inc_size=4;
   angolo; inc_x=70;
BEGIN
   file=file_oggetti;
   z=-110; x=399; y=299;
   graph=grafico;
   signal(father, s_freeze);
   sound(record_pcm,256,256);
   size=-4; // per evitare che sia diventi troppo grande
   FROM angolo=0 TO (4*PI) STEP(20000);
      size+=inc_size;
      angle=angolo;
      FRAME;
   END;
   timer=0;
   REPEAT FRAME; UNTIL(timer>200);

   REPEAT
      x+=inc_x;
      FRAME;
   UNTIL (out_region(id, 0));

   signal(father, s_wakeup);

END; // NEW_RECORD

//============================= ESPLOSIONE_CHAR

PROCESS esplosione_char(x,y);
PRIVATE
   grafico[] = 10,11,12,13,14,15; i;
BEGIN
   file=file_oggetti;
   z=-5;
   sound(esplosione_pcm,256,256);
   FROM i=0 TO 5;
      graph=grafico[i];
      FRAME;
   END;
END; // ESPLOSIONE_CHAR

//=============================







