//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

PROGRAM BubbleMachine;

//////////////////////////////////////////////////////////////////////////////
//GLOBAL///////////////////////////////////////////////////////////////////////

GLOBAL
  ballfont;

  here;tac;ioup;piou;looser;quake;cash;

  mode=0;
  keyb;
  mtr;
  incy;incx;
  time_inc;canon_y;tremble;
  renvoi;

  id_socle;
  id_canon;
  id_limite;
  id_ball;
  id_wall1;id_wall2;
  id_guy;

  ox=272000;oy=45000;         //offset matrix

  STRUCT m_[150];             //matrice L=10/H=15
            mx;               //x
            my;               //y
            col;              //ball color at x,y
            des;              //destruction flag
            grav;        //gravity flag (when a ball isn't hanged)
  END
  miss=0;

//GLOBAL///////////////////////////////////////////////////////////////////////

PRIVATE n=0;inc1;inc2;id_txt1;
        mv;        //placement in matrix
    des_chain[6];    //destruction chain (each ball got 6 neighbors)(value=0 not used)
    inc_des;    

//BEGIN///////////////////////////////////////////////////////////////////////

BEGIN

  resolution=1000;

  load_fpg("f:\div\bam\bam.fpg");
  ballfont=load_fnt("f:\div\bam\bam.fnt");
  here=load_pcm("f:\div\bam\sons\here.pcm",0);
  tac=load_pcm("f:\div\bam\sons\tac.pcm",0);
  piou=load_pcm("f:\div\bam\sons\piou.pcm",0);
  ioup=load_pcm("f:\div\bam\sons\ioup.pcm",0);
  looser=load_pcm("f:\div\bam\sons\looser.pcm",0);
  quake=load_pcm("f:\div\bam\sons\quake.pcm",0);
  cash=load_pcm("f:\div\bam\sons\cash.pcm",0);

  set_mode(m1024x768);

  set_fps(100,0);

  write(ballfont,512,300,1,"VINIC GAMES");
  FROM n=0 to 500;FRAME;END
  delete_text(all_text);

  put(0,999,512,384);

  put(0,998,512,405);

//BEGIN///////////////////////////////////////////////////////////////////////
//LOOP////////////////////////////////////////////////////////////////////////

LOOP

IF(MODE==0)        //mode=0 is to init all values

  time_inc=0;    //used for platform elevation
  canon_y=0;    //used for platform elevation
  miss=0;    //flag. =1 when a ball is under the limit
  n=0;

  id_wall1=wall(268000,0);
  id_wall2=wall(752000,180000);
  top();
  id_socle=socle();        //socle=platform
  id_guy=guy();
  id_canon=canon();
  id_limite=limite();
  id_ball=ball(rand(1,7));    //seven colors used for private "mycol"


//fills matrix with FOR loop, instead of typing one by one each value

  FOR (incy=1;incy<=13;incy+=2)              //lines 1,3,5,7,9,11,13
    FOR (incx=1;incx<=10;incx+=1)
      m_[(incx+(incy*10))-10].mx=ox+(48000/2)+(48000*(incx-1));
      m_[(incx+(incy*10))-10].my=oy+(48000/2)+(42000*(incy-1));
      m_[(incx+(incy*10))-10].des=0;
      m_[(incx+(incy*10))-10].col=0;
    END
  END

  FOR (incy=2;incy<=13;incy+=2)              //lines 2,4,6,8,10,12
    FOR (incx=1;incx<=10;incx+=1)
      m_[(incx+(incy*10))-10].mx=ox+(48000)+(48000*(incx-1));
      m_[(incx+(incy*10))-10].my=oy+(45500+(42000/2))+(42000*(incy-2));
      m_[(incx+(incy*10))-10].des=0;
      m_[(incx+(incy*10))-10].col=0;
    END
  END

  id_txt1=write(ballfont,512,300,1,"WAIT...");
  FROM n=0 to 150;
    if(n==100)sound(here,256,256);
      delete_text(id_txt1);
      id_txt1=write(ballfont,512,300,1,"GO!");
    END
    fade(100,100,100,5);FRAME;
  END

  delete_text(id_txt1);
  MODE=1;
END


IF(MODE==1)        //mode=1 is for gameplay

    if(key(_esc))exit("VINIC GAMES - Work In Progress",0);END

//Here are the lines that make the platform quake and lift
    time_inc+=1;
    if(time_inc>2000)
      if (time_inc/4)
        tremble+=2000;sound(quake,30,rand(200,500));
      else
        tremble-=2000;
      END
    END
    if(time_inc>2300) tremble=0;canon_y-=42000;time_inc=0;sound(ioup,50,500);END

//Avoid key repetition
    if(key(_space)) keyb+=1; else keyb=0; END

//turns arrow / tac tac tac sound / character's animation
    if (key(_left))
      id_canon.angle+=1000;
      if (id_canon.angle>65000) id_canon.angle=65000; END
      inc1+=1;
      if(id_canon.angle<>65000)
        inc2+=1;if(inc2>39)inc2=0;END
        if(inc1>9)inc1=0;sound(tac,56,600);END
      END
    END

    if (key(_right))
      id_canon.angle-=1000;
      if (id_canon.angle<-65000)id_canon.angle=-65000;END
      inc1+=1;
      if (id_canon.angle<>-65000)
        inc2-=1;if(inc2<0)inc2=39;END
        if(inc1>9)inc1=0;sound(tac,56,600);END
      END
    END

    id_guy.graph=201+(inc2/5);

//if a ball is under the limit
    if(miss==1)
      n=0;
      REPEAT
        delete_text(all_text);
        write(ballfont,270,820-(n*3/2),1,"L");
        write(ballfont,370,850-(n*3/2),1,"O");
        write(ballfont,470,810-(n*3/2),1,"S");
        write(ballfont,570,790-(n*3/2),1,"E");
        write(ballfont,670,830-(n*3/2),1,"R");
        write(ballfont,770,800-(n*3/2),1,"!");
        if(n==4)sound(looser,256,400);END
        n+=4;if(n>500)fade(0,0,0,1);END
        FRAME;
      UNTIL (n>700);let_me_alone();delete_text(all_text);mode=0;
    END




//--------------------------------------------------------------------------
//--------------------------------------------------------------------------
//--------------------------------------------------------------------------
/*--------------------CHECKING NEIGHBORS BALLS
Have a look to SNAP.PCX for more clarity...
mv is Matrix Value = placement/adress in matrix...
it's numbers you will see on snapshot.
inc_des is incrementation of neighbor balls with same color.
I use this inc_des as an adress in des_chain[] = destruction chain
which stores Matrix Values(mv) with same color.
*/
FROM mv=1 to 139;

  inc_des=0;
  IF(m_[mv].col<>0)
    if((mv-1)/10==0 or (mv-1)/10==2 or (mv-1)/10==4 or (mv-1)/10==6 or (mv-1)/10==8 or (mv-1)/10==10 or (mv-1)/10==12)
      if(mv>11 AND mv<>21 AND mv<>41 AND mv<>61 AND mv<>81 AND mv<>101 AND mv<>121)
        if(m_[mv].col==m_[mv-11].col) inc_des+=1;des_chain[inc_des]=mv-11;END
      END

      if(mv<>21 AND mv<>41 AND mv<>61 AND mv<>81 AND mv<>101 AND mv<>121)
        if(m_[mv].col==m_[mv+9].col) inc_des+=1;des_chain[inc_des]=mv+9;END
      END
    END
    if((mv-1)/10==1 or (mv-1)/10==3 or (mv-1)/10==5 or (mv-1)/10==7 or (mv-1)/10==9 or (mv-1)/10==11 or (mv-1)/10==13)
      if(mv>9)
        if(m_[mv].col==m_[mv-9].col) inc_des+=1;des_chain[inc_des]=mv-9;END
      END
      if(m_[mv].col==m_[mv+11].col)   inc_des+=1;des_chain[inc_des]=mv+11;END
    END

    if(m_[mv].col==m_[mv+10].col)   inc_des+=1;des_chain[inc_des]=mv+10;END

    if(mv>10)
      if(m_[mv].col==m_[mv-10].col) inc_des+=1;des_chain[inc_des]=mv-10;END
    END

    if(mv>1 AND mv<>11 AND mv<>31 AND mv<>51 AND mv<>71 AND mv<>91 AND mv<>111)
      if(m_[mv].col==m_[mv-1].col) inc_des+=1;des_chain[inc_des]=mv-1;END
    END

    if(mv<>10 AND mv<>30 AND mv<>50 AND mv<>70 AND mv<>90 AND mv<>110 AND mv<>130)
      if(m_[mv].col==m_[mv+1].col) inc_des+=1;des_chain[inc_des]=mv+1;END
    END

//If there 2 or more same colored balls, put their destruction flag on(=1)
//Have your first Aspirin... ;)
    if(inc_des>=2)
      FOR (n=1;n<=inc_des;n+=1); m_[des_chain[n]].des=1;END
      m_[mv].des=1;
    END
  END
END

//Almost the same thing, easier, for not hanged balls.

  FROM mv=1 to 139;m_[mv].grav=1;END    //put all the flags to 1

  FROM mv=1 to 139;
  IF(m_[mv].col<>0)        //to only check Matrix Values with a ball
    IF (mv<=10) m_[mv].grav=0;END    //mv<=10 means it touches top

//then, if a ball is linked to top, turn its neighbor's flag to OFF(=0)
    IF (m_[mv].grav==0)
      if((mv-1)/10==0 or (mv-1)/10==2 or (mv-1)/10==4 or (mv-1)/10==6 or (mv-1)/10==8 or (mv-1)/10==10 or (mv-1)/10==12)
        if(mv>11 AND mv<>21 AND mv<>41 AND mv<>61 AND mv<>81 AND mv<>101 AND mv<>121)
          m_[mv-11].grav=0;
        END

        if(mv<>21 AND mv<>41 AND mv<>61 AND mv<>81 AND mv<>101 AND mv<>121)
          m_[mv+09].grav=0;
        END
      ELSE
        if(mv>9)
          m_[mv-09].grav=0;
        END
        m_[mv+11].grav=0;
      END
      m_[mv+10].grav=0;
      if(mv>10)
        m_[mv-10].grav=0;
      END
      if(mv>1 AND mv<>11 AND mv<>31 AND mv<>51 AND mv<>71 AND mv<>91 AND mv<>111)
        m_[mv-01].grav=0;
      END
      if(mv<>10 AND mv<>30 AND mv<>50 AND mv<>70 AND mv<>90 AND mv<>110 AND mv<>130)
        m_[mv+01].grav=0;
      END

    END
  END
  END


FRAME;





//--------------------------------------------------------------------------
//--------------------------------------------------------------------------
//--------------------------------------------------------------------------
END
END
END

//LOOP/////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////
///////P/////////////////////////////////////////////////////////////////////////////
///////R/////////////////////////////////////////////////////////////////////////////
///////O/////////////////////////////////////////////////////////////////////////////
///////C/////////////////////////////////////////////////////////////////////////////
///////E/////////////////////////////////////////////////////////////////////////////
///////S/////////////////////////////////////////////////////////////////////////////
//PROCESSUS/////////////////////////////////////////////////////////////////////////////
///////U/////////////////////////////////////////////////////////////////////////////
///////S/////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////// process

PROCESS ball(mycol)

PRIVATE
  n;

  mycol;      //ball color
  shoted;   //quite obvious, if ball has been shoted
  shot_angle; //...do I need?
  placed;     //...
  mv_;    //Matrix Value, but for private ends

  difx;dify;
  incx_buf;incy_buf;
  difx_buf=666666666;dify_buf=666666666;abs_dif;

BEGIN
  resolution=1000;
  size=100;
  graph=500+mycol-1;
  LOOP

    IF (m_[mv_].des==1);    //if destruction flag is on...
      sound(piou,56,356);
      FOR(n=100;n>=0;n-=10);    //reduces ball's size
        size=n;FRAME;
      END
      m_[mv_].col=0;        //resets
      m_[mv_].des=0;        //Matrix Values
      RETURN;
    END

    IF(m_[mv_].grav==1)        //the same for grvity flag
      sound(cash,30,256);
      FOR(n=100;n>=0;n-=10);
        size=n;y-=n*400;FRAME;    //reduces ball's size and throw it up!
      END
      m_[mv_].col=0;
      m_[mv_].des=0;
      RETURN;
    END

    if(shoted==0)x=id_canon.x;y=id_canon.y;END

    if (y>id_limite.y and placed==1) miss=1;END

    if (key(_space) and shoted==0 and keyb==1)

      sound(ioup,256,256);
      shoted=1;
      shot_angle=id_canon.angle+90000;
      angle=shot_angle;

      loop  //----------------------------- MOVE & PLACEMENT LOOP

        angle=shot_angle;    //takes the angle of shot
        advance(15000);        //advance
        angle=0;        //then turn back the ball to angle=0 before FRAME

        if(collision(TYPE wall))
          shot_angle=180000-shot_angle;
          angle=shot_angle;
          advance(15000);
          angle=0;FRAME;
        END


        if(collision(TYPE ball) or collision(TYPE top))

          FROM incy=1 to 13;            //gets nearest Y value in Matrix
            dify=y-m_[incy*10].my;
            abs_dif=abs(dify);
            if (abs_dif<dify_buf) dify_buf=dify;incy_buf=incy;END
          END
          if (incy_buf)difx=x-m_[incx]; //gets nearest X value in Matrix
            FROM incx=1 to 10;          //lines1,3,5...
              difx=x-m_[incx].mx;
              abs_dif=abs(difx);
              if (abs_dif<difx_buf) difx_buf=difx;incx_buf=incx;END
            END
          ELSE
            FROM incx=11 to 19;         //gets nearest X value in Matrix
              difx=x-m_[incx].mx;       //lines 2,4,8...
              abs_dif=abs(difx);
              if (abs_dif<difx_buf) difx_buf=difx;incx_buf=incx-10;END
            END
          END

          mv_=(incx_buf+(incy_buf*10))-10;    //defines Matrix Value/adress
          m_[mv_].col=mycol;            //set this adress color to the ball one

          x=m_[mv_].mx;            //places ball x
          y=m_[mv_].my;            //places ball y

      placed=1;            //ball is placed!!!

          BREAK;
        END
        FRAME;

      END    //----------------------------- END OF MOVE & PLACEMENT LOOP

      angle=0;
      id_ball=ball(rand(1,7));  //cration d'une nouvelle balle


    END
    FRAME;

  END

END




//////////////////////////////////////////////////////////////// process

PROCESS canon()
BEGIN
  resolution=1000;
  graph=1;
  size=65;
  x=511000;
  LOOP
    y=id_socle.y;
    FRAME;
  END
END

//////////////////////////////////////////////////////////////// process

PROCESS wall(x,angle)
BEGIN
  resolution=1000;
  graph=3;
  size=350;
  y=384000;
  LOOP
    FRAME;
  END
END

//////////////////////////////////////////////////////////////// process

PROCESS top()
BEGIN
  resolution=1000;
  angle=-90000;
  graph=3;
  size=500;
  x=512000;y=45000;
  LOOP
    FRAME;
  END
END

//////////////////////////////////////////////////////////////// process

PROCESS guy()
BEGIN
  graph=201;
  resolution=1000;
  size=100;
  x=304000;z=-200;
  LOOP
    y=id_socle.y-46000;
    FRAME;
  END
END

//////////////////////////////////////////////////////////////// process

PROCESS socle()

BEGIN
  resolution=1000;
  size=100;
  x=512000;
  graph=4;
  LOOP
    y=700000+canon_y+tremble;
    FRAME;
  END

END
//////////////////////////////////////////////////////////////// process

PROCESS limite()
BEGIN
  resolution=1000;
  size=100;
  x=512000;
  graph=5;
  LOOP
    y=568000+canon_y+tremble;
    FRAME;
  END
END

//////////////////////////////////////////////////////////////// process

PROCESS test1(x,y,graph)
BEGIN
  resolution=1000;
  size=300;
  z=200;
  LOOP
    if(x>750000)BREAK;END
    FRAME;
  END
END


