/*
max. hexadecimal:2147483647
HERTZ:  FREQUENCY:
 8000         110
16000         320
44100        1025 <--
*/

Program Easy_Rhythm_Generator;
Global
    MouseStatus;
    Struct Alternative;
        Struct HiHat;
            Closed;
            Peddal;
            Open;
        End
        Struct Crash;
            Normal;
            Reversed;
        End
        Base;
        Struct Snare;
            Normal;
            Dry;
            Short;
            Damped;
        End
        Struct Tom;
            High;
            Middle;
            Low;
        End
        Struct FX;
            #1;
            #2;
            #3;
            #4;
        End
    End
    Struct Rhythm;
        Speed;
        #1[128];
        #2[128];
        #3[128];
        #4[128];
        #5[128];
        #6[128];
        #7[128];
        #8[128];
        #9[128];
        Buffer;
    End
    SelectedSound;
    Playing;
    Timing;
Begin
    Load_Fnt("Wit.fnt");
    Write(1,512,384,4,"Loading...");
    Set_Mode(1024768);
    Frame(100);
    Load_Fpg("Drum.Fpg");
    Alternative.HiHat.Closed=Load_PCM("C:\DIV\WAV\DRUM\Alternat\HiHat_Cl.wav",0);
    Alternative.HiHat.Peddal=Load_PCM("C:\DIV\WAV\DRUM\Alternat\HiHat_Pd.wav",0);
    Alternative.HiHat.Open=Load_PCM("C:\DIV\WAV\DRUM\Alternat\HiHat_Op.wav",0);
    Alternative.Crash.Normal=Load_PCM("C:\DIV\WAV\DRUM\Alternat\Crash.wav",0);
    Alternative.Crash.Reversed=Load_PCM("C:\DIV\WAV\DRUM\Alternat\FXCrash.wav",0);
    Alternative.Snare.Normal=Load_PCM("C:\DIV\WAV\DRUM\Alternat\Snare.wav",0);
    Alternative.Snare.Damped=Load_PCM("C:\DIV\WAV\DRUM\Alternat\Snare_DM.wav",0);
    Alternative.Snare.Dry=Load_PCM("C:\DIV\WAV\DRUM\Alternat\Snare_DR.wav",0);
    Alternative.Snare.Short=Load_PCM("C:\DIV\WAV\DRUM\Alternat\Snare_SH.wav",0);
    Alternative.Base=Load_PCM("C:\DIV\WAV\DRUM\Alternat\Base.wav",0);
    Alternative.Tom.High=Load_PCM("C:\DIV\WAV\DRUM\Alternat\HighTom.wav",0);
    Alternative.Tom.Middle=Load_PCM("C:\DIV\WAV\DRUM\Alternat\MidTom.wav",0);
    Alternative.Tom.Low=Load_PCM("C:\DIV\WAV\DRUM\Alternat\LowTom.wav",0);
    Alternative.FX.#1=Load_PCM("C:\DIV\WAV\DRUM\Alternat\FX1.wav",0);
    Alternative.FX.#2=Load_PCM("C:\DIV\WAV\DRUM\Alternat\FX2.wav",0);
    Alternative.FX.#3=Load_PCM("C:\DIV\WAV\DRUM\Alternat\Clap.wav",0);
    Alternative.FX.#4=Load_PCM("C:\DIV\WAV\DRUM\Alternat\Sticks.wav",0);
    From X=0 to 1024;
        From Y=0 to 768;
            Put_Pixel(X,Y,3);
        End
    End
    Rhythm.Speed=150;
    Rhythm.Buffer=57;
    Delete_Text(All_Text);
    Fade(100,100,100,1);
    Write(1,512,354,4,"PBgames pressents:");
    Write(1,512,394,4,"Easy Rhythm Generator");
    From X=1 to 80;
        If(Key(_Enter)|Key(_Space))
            Fade(100,100,100,1000);
            Break;
        End
        Frame(100);
    End
    Delete_Text(All_Text);
    Version();
    Frame(100);
    Start_All();
End

Process Version();
Begin
    Write(0,1023,767,8,"Alternative Edition 0.01c");
    Write(0,2,767,6,"Copyright 2002: Pieter-Bart van Splunter");
End

Process Start_All();
Begin
    Set_Screen();
    Close_Button();
    Backenset_Screen();
    Drumset_Screen();
    Effectsset_Screen();
    Options_Screen();
    Set_Rhythm();
    Play_Rhythm();
    Time_Bar();
    Reset();
    Mouse.Graph=999;
End

Process Set_Screen();
Begin
    From X=0 to 1024;
        From Y=0 to 10;
            Put_Pixel(X,Y,15);
        End
        From Y=562 to 768;
            Put_Pixel(X,Y,4);
        End
        From Y=552 to 561;
            Put_Pixel(X,Y,5);
        End
        From Y=758 to 767;
            Put_Pixel(X,Y,5);
        End
        Put_Pixel(X,560,6);
        Put_Pixel(X,551,7);
        Put_Pixel(X,767,6);
        Put_Pixel(X,757,7);
    End
    From Y=551 to 560;
        Put_Pixel(0,Y,7);
        Put_Pixel(1023,Y,6);
    End
    From Y=757 to 767;
        Put_Pixel(0,Y,7);
        Put_Pixel(1023,Y,6);
    End
    Put(0,800,512,6);
End

Process Backenset_Screen();
Begin
    From Y=551 to 758;
        Put_Pixel(700,Y,7);
    End
    Write(0,703,561,6,"Backenset:");
    Alternative_Closed_HiHat_Button();
    Alternative_Peddal_HiHat_Button();
    Alternative_Open_HiHat_Button();
    Alternative_Normal_Crash_Button();
    Alternative_Reversed_Crash_Button();
End

Process Drumset_Screen();
Begin
    From Y=551 to 758;
        Put_Pixel(300,Y,7);
    End
    Write(0,303,561,6,"Drumset:");
    Alternative_Base_Button();
    Alternative_Normal_Snare_Button();
    Alternative_Dry_Snare_Button();
    Alternative_Short_Snare_Button();
    Alternative_Damped_Snare_Button();
    Alternative_High_tom_Button();
    Alternative_Middle_tom_Button();
    Alternative_Low_tom_Button();
End

Process Effectsset_Screen();
Begin
    From Y=551 to 758;
        Put_Pixel(200,Y,7);
    End
    Write(0,203,561,6,"Effectsset:");
    Alternative_FX1_Button();
    Alternative_FX2_Button();
    Alternative_FX3_Button();
    Alternative_FX4_Button();
End

Process Options_Screen();
Private
    Nr="Verry slow";
    T;
Begin
    From Y=551 to 758;
        Put_Pixel(0,Y,7);
    End
    Write(0,3,561,6,"Options:");
    Write(0,3,573,6,"Speed:");
    Write(0,3,610,6,"Buffer:");
    Write_Int(0,70,610,6,&Rhythm.Buffer);
    T=Write(0,75,573,6,Nr);
    Faster_Button();
    Slower_Button();
    Smaller_Button();
    Bigger_Button();
    Save_Button();
    Load_Button();
    Reset_Button();
    Play_Button();
    Pause_Button();
    Stop_Button();
    Loop
        Switch(Rhythm.Speed);
            Case 50:
                Nr="Verry Fast";
            End
            Case 100:
                Nr="Fast";
            End
            Case 150:
                Nr="Normal";
            End
            Case 200:
                Nr="Slow";
            End
            Case 250:
                Nr="Verry Slow";
            End
            Default:
                Nr="Error!";
            End
        End
        Delete_Text(T);
        T=Write(0,75,573,6,Nr);
        Frame(100);
    End
End

Process Close_Button();
Begin
    Graph=1;
    X=1019;
    Y=556;
    Loop
        If(MouseStatus==0&&Collision(Type Mouse)&&Mouse.Left);
            MouseStatus=ID;
            While(Mouse.Left)
                If(Collision(Type Mouse))
                    X=1018;
                    Flags=5;
                Else
                    X=1019;
                    Flags=0;
                End
                Frame(100);
            End
            If(Collision(Type Mouse))
                Fade(0,0,0,1);
                While(Fading)
                    Frame(100);
                End
                Exit("Bye!",0);
            End
            X=1019;
            MouseStatus=0;
        End
        If(Key(_Esc))
            Fade(0,0,0,1);
            while(Fading)
                Frame(100);
            End
            Exit("Bye!",0);
        End
        Frame(100);
    End
End

Process Slower_Button();
Begin
    Graph=6;
    X=45;
    Y=569;
    Loop
        If(MouseStatus==0&&Collision(Type Mouse)&&Mouse.Left);
            MouseStatus=ID;
            While(Mouse.Left)
                If(Collision(Type Mouse))
                    X=44;
                    Flags=5;
                Else
                    X=45;
                    Flags=0;
                End
                Frame(100);
            End
            If(Collision(Type Mouse)&&Rhythm.Speed<250)
                Rhythm.Speed+=50;
            End
            X=45;
            Flags=0;
            MouseStatus=0;
        End
        Frame(100);
    End
End

Process Faster_Button();
Begin
    Graph=7;
    X=60;
    Y=569;
    Loop
        If(MouseStatus==0&&Collision(Type Mouse)&&Mouse.Left);
            MouseStatus=ID;
            While(Mouse.Left)
                If(Collision(Type Mouse))
                    X=59;
                    Flags=5;
                Else
                    X=60;
                    Flags=0;
                End
                Frame(100);
            End
            If(Collision(Type Mouse)&&Rhythm.Speed>50)
                Rhythm.Speed-=50;
            End
            X=60;
            Flags=0;
            MouseStatus=0;
        End
        Frame(100);
    End
End

Process Save_Button();
Begin
    Graph=8;
    X=15;
    Y=581;
    Loop
        If(MouseStatus==0&&Collision(Type Mouse)&&Mouse.Left);
            MouseStatus=ID;
            While(Mouse.Left)
                If(Collision(Type Mouse))
                    Flags=4;
                Else
                    Flags=0;
                End
                Frame(100);
            End
            If(Collision(Type Mouse))
                Save("Rhythm.RTM",OffSet Rhythm,SizeOf(Rhythm));
            End
            Flags=0;
            MouseStatus=0;
        End
        Frame(100);
    End
End

Process Load_Button();
Begin
    Graph=9;
    X=42;
    Y=581;
    Loop
        If(MouseStatus==0&&Collision(Type Mouse)&&Mouse.Left);
            MouseStatus=ID;
            While(Mouse.Left)
                If(Collision(Type Mouse))
                    Flags=4;
                Else
                    Flags=0;
                End
                Frame(100);
            End
            If(Collision(Type Mouse))
                Fade(10,10,10,10);
                While(Fading)
                    Frame(100);
                End
                Let_Me_Alone();
                Delete_Text(All_Text);
                Clear_Screen();
                Write(1,512,384,4,"Loading...");
                Frame(100);
                Load("Rhythm.RTM",OffSet Rhythm);
                Reset();
                Delete_Text(All_Text);
                Version();
                Start_All();
                Fade(100,100,100,10);
                While(Fading)
                    Frame(100);
                End
                MouseStatus=0;
                Break;
            End
            Flags=0;
            MouseStatus=0;
        End
        Frame(100);
    End
End

Process Reset_Button();
Begin
    Graph=13;
    X=71;
    Y=581;
    Loop
        If(MouseStatus==0&&Collision(Type Mouse)&&Mouse.Left);
            MouseStatus=ID;
            While(Mouse.Left)
                If(Collision(Type Mouse))
                    Flags=4;
                Else
                    Flags=0;
                End
                Frame(100);
            End
            If(Collision(Type Mouse))
                From Z=0 to 128;
                    Rhythm.#1[Z]=0;
                    Rhythm.#2[Z]=0;
                    Rhythm.#3[Z]=0;
                    Rhythm.#4[Z]=0;
                    Rhythm.#5[Z]=0;
                    Rhythm.#6[Z]=0;
                    Rhythm.#7[Z]=0;
                    Rhythm.#8[Z]=0;
                    Rhythm.#9[Z]=0;
                End
                Reset();
            End
            Flags=0;
            MouseStatus=0;
        End
        Frame(100);
    End
End

Process Play_Button();
Begin
    Graph=10;
    X=15;
    Y=593;
    Loop
        If(MouseStatus==0&&Collision(Type Mouse)&&Mouse.Left);
            MouseStatus=ID;
            While(Mouse.Left)
                If(Collision(Type Mouse))
                    Flags=4;
                Else
                    Flags=0;
                End
                Frame(100);
            End
            If(Collision(Type Mouse))
                Playing=1;
            End
            Flags=0;
            MouseStatus=0;
        End
        While(Key(_Space)&&Playing==0)
            Flags=4;
            Frame(100);
            Flags=0;
        End
        Frame(100);
    End
End

Process Pause_Button();
Begin
    Graph=11;
    X=43;
    Y=593;
    Loop
        If(MouseStatus==0&&Collision(Type Mouse)&&Mouse.Left);
            MouseStatus=ID;
            While(Mouse.Left)
                If(Collision(Type Mouse))
                    Flags=4;
                Else
                    Flags=0;
                End
                Frame(100);
            End
            If(Collision(Type Mouse))
                Playing=0;
            End
            Flags=0;
            MouseStatus=0;
        End
        Frame(100);
    End
End

Process Stop_Button();
Begin
    Graph=12;
    X=72;
    Y=593;
    Loop
        If(MouseStatus==0&&Collision(Type Mouse)&&Mouse.Left);
            MouseStatus=ID;
            While(Mouse.Left)
                If(Collision(Type Mouse))
                    Flags=4;
                Else
                    Flags=0;
                End
                Frame(100);
            End
            If(Collision(Type Mouse))
                Timing=Playing=0;
            End
            Flags=0;
            MouseStatus=0;
        End
        While(Key(_Space)&&Playing==1)
            Flags=4;
            Frame(100);
            Flags=0;
        End
        Frame(100);
    End
End

Process Smaller_Button();
Begin
    Graph=6;
    X=50;
    Y=605;
    Loop
        If(MouseStatus==0&&Collision(Type Mouse)&&Mouse.Left);
            MouseStatus=ID;
            While(Mouse.Left)
                If(Collision(Type Mouse))
                    Flags=4;
                Else
                    Flags=0;
                End
                Frame(100);
            End
            If(Collision(Type Mouse)&&Rhythm.Buffer>1)
                Rhythm.Buffer--;
            End
            Flags=0;
            MouseStatus=0;
        End
        Frame(100);
    End
End

Process Bigger_Button();
Begin
    Graph=7;
    X=62;
    Y=605;
    Loop
        If(MouseStatus==0&&Collision(Type Mouse)&&Mouse.Left);
            MouseStatus=ID;
            While(Mouse.Left)
                If(Collision(Type Mouse))
                    Flags=4;
                Else
                    Flags=0;
                End
                Frame(100);
            End
            If(Collision(Type Mouse)&&Rhythm.Buffer<125)
                Rhythm.Buffer++;
            End
            Flags=0;
            MouseStatus=0;
        End
        Frame(100);
    End
End

Process Reset();
Private
    Position;
    T;
Begin
    From Position=0 to 128;
        Switch(Rhythm.#1[Position])
            Case 0:
                T=801;
            End
            Case 1..3:
                T=500;
            End
            Case 4..5:
                T=501;
            End
            Case 6:
                T=502;
            End
            Case 7..10:
                T=503;
            End
            Case 11..13:
                T=504;
            End
            Case 14..17:
                T=505;
            End
        End
        Put(File,T,Position*8,11);
        Switch(Rhythm.#2[Position])
            Case 0:
                T=801;
            End
            Case 1..3:
                T=500;
            End
            Case 4..5:
                T=501;
            End
            Case 6:
                T=502;
            End
            Case 7..10:
                T=503;
            End
            Case 11..13:
                T=504;
            End
            Case 14..17:
                T=505;
            End
        End
        Put(File,T,Position*8,71);
        Switch(Rhythm.#3[Position])
            Case 0:
                T=801;
            End
            Case 1..3:
                T=500;
            End
            Case 4..5:
                T=501;
            End
            Case 6:
                T=502;
            End
            Case 7..10:
                T=503;
            End
            Case 11..13:
                T=504;
            End
            Case 14..17:
                T=505;
            End
        End
        Put(File,T,Position*8,131);
        Switch(Rhythm.#4[Position])
            Case 0:
                T=801;
            End
            Case 1..3:
                T=500;
            End
            Case 4..5:
                T=501;
            End
            Case 6:
                T=502;
            End
            Case 7..10:
                T=503;
            End
            Case 11..13:
                T=504;
            End
            Case 14..17:
                T=505;
            End
        End
        Put(File,T,Position*8,191);
        Switch(Rhythm.#5[Position])
            Case 0:
                T=801;
            End
            Case 1..3:
                T=500;
            End
            Case 4..5:
                T=501;
            End
            Case 6:
                T=502;
            End
            Case 7..10:
                T=503;
            End
            Case 11..13:
                T=504;
            End
            Case 14..17:
                T=505;
            End
        End
        Put(File,T,Position*8,251);
        Switch(Rhythm.#6[Position])
            Case 0:
                T=801;
            End
            Case 1..3:
                T=500;
            End
            Case 4..5:
                T=501;
            End
            Case 6:
                T=502;
            End
            Case 7..10:
                T=503;
            End
            Case 11..13:
                T=504;
            End
            Case 14..17:
                T=505;
            End
        End
        Put(File,T,Position*8,311);
        Switch(Rhythm.#7[Position])
            Case 0:
                T=801;
            End
            Case 1..3:
                T=500;
            End
            Case 4..5:
                T=501;
            End
            Case 6:
                T=502;
            End
            Case 7..10:
                T=503;
            End
            Case 11..13:
                T=504;
            End
            Case 14..17:
                T=505;
            End
        End
        Put(File,T,Position*8,371);
        Switch(Rhythm.#8[Position])
            Case 0:
                T=801;
            End
            Case 1..3:
                T=500;
            End
            Case 4..5:
                T=501;
            End
            Case 6:
                T=502;
            End
            Case 7..10:
                T=503;
            End
            Case 11..13:
                T=504;
            End
            Case 14..17:
                T=505;
            End
        End
        Put(File,T,Position*8,431);
        Switch(Rhythm.#9[Position])
            Case 0:
                T=801;
            End
            Case 1..3:
                T=500;
            End
            Case 4..5:
                T=501;
            End
            Case 6:
                T=502;
            End
            Case 7..10:
                T=503;
            End
            Case 11..13:
                T=504;
            End
            Case 14..17:
                T=505;
            End
        End
        Put(File,T,Position*8,491);
    End
End

//_____________________________Instruments:___________________________________

Process Alternative_Closed_HiHat_Button();
Begin
    Graph=100;
    X=734;
    Y=569;
    Loop
        If(MouseStatus==0&&Collision(Type Mouse)&&Mouse.Left);
            MouseStatus=ID;
            While(Mouse.Left)
                If(Collision(Type Mouse))
                    Flags=4;
                Else
                    Flags=0;
                End
                Frame(100);
            End
            If(Collision(Type Mouse))
                Sound(Alternative.HiHat.Closed,256,1025);
                SelectedSound=1;
            End
            Flags=0;
            MouseStatus=0;
        End
        Frame(100);
    End
End

Process Alternative_Peddal_HiHat_Button();
Begin
    Graph=101;
    X=799;
    Y=569;
    Loop
        If(MouseStatus==0&&Collision(Type Mouse)&&Mouse.Left);
            MouseStatus=ID;
            While(Mouse.Left)
                If(Collision(Type Mouse))
                    Flags=4;
                Else
                    Flags=0;
                End
                Frame(100);
            End
            If(Collision(Type Mouse))
                Sound(Alternative.HiHat.Peddal,256,1025);
                SelectedSound=2;
            End
            Flags=0;
            MouseStatus=0;
        End
        Frame(100);
    End
End

Process Alternative_Open_HiHat_Button();
Begin
    Graph=102;
    X=859;
    Y=569;
    Loop
        If(MouseStatus==0&&Collision(Type Mouse)&&Mouse.Left);
            MouseStatus=ID;
            While(Mouse.Left)
                If(Collision(Type Mouse))
                    Flags=4;
                Else
                    Flags=0;
                End
                Frame(100);
            End
            If(Collision(Type Mouse))
                Sound(Alternative.HiHat.Open,256,1025);
                SelectedSound=3;
            End
            Flags=0;
            MouseStatus=0;
        End
        Frame(100);
    End
End

Process Alternative_Normal_Crash_Button();
Begin
    Graph=103;
    X=975;
    Y=569;
    Loop
        If(MouseStatus==0&&Collision(Type Mouse)&&Mouse.Left);
            MouseStatus=ID;
            While(Mouse.Left)
                If(Collision(Type Mouse))
                    Flags=4;
                Else
                    Flags=0;
                End
                Frame(100);
            End
            If(Collision(Type Mouse))
                Sound(Alternative.Crash.Normal,256,1025);
                SelectedSound=4;
            End
            Flags=0;
            MouseStatus=0;
        End
        Frame(100);
    End
End

Process Alternative_Reversed_Crash_Button();
Begin
    Graph=104;
    X=923;
    Y=569;
    Loop
        If(MouseStatus==0&&Collision(Type Mouse)&&Mouse.Left);
            MouseStatus=ID;
            While(Mouse.Left)
                If(Collision(Type Mouse))
                    Flags=4;
                Else
                    Flags=0;
                End
                Frame(100);
            End
            If(Collision(Type Mouse))
                Sound(Alternative.Crash.Reversed,256,1025);
                SelectedSound=5;
            End
            Flags=0;
            MouseStatus=0;
        End
        Frame(100);
    End
End

Process Alternative_Base_Button();
Begin
    Graph=105;
    X=315;
    Y=569;
    Loop
        If(MouseStatus==0&&Collision(Type Mouse)&&Mouse.Left);
            MouseStatus=ID;
            While(Mouse.Left)
                If(Collision(Type Mouse))
                    Flags=4;
                Else
                    Flags=0;
                End
                Frame(100);
            End
            If(Collision(Type Mouse))
                Sound(Alternative.Base,256,1025);
                SelectedSound=6;
            End
            Flags=0;
            MouseStatus=0;
        End
        Frame(100);
    End
End

Process Alternative_Normal_Snare_Button();
Begin
    Graph=106;
    X=343;
    Y=569;
    Loop
        If(MouseStatus==0&&Collision(Type Mouse)&&Mouse.Left);
            MouseStatus=ID;
            While(Mouse.Left)
                If(Collision(Type Mouse))
                    Flags=4;
                Else
                    Flags=0;
                End
                Frame(100);
            End
            If(Collision(Type Mouse))
                Sound(Alternative.Snare.Normal,256,1025);
                SelectedSound=7;
            End
            Flags=0;
            MouseStatus=0;
        End
        Frame(100);
    End
End

Process Alternative_Dry_Snare_Button();
Begin
    Graph=107;
    X=383;
    Y=569;
    Loop
        If(MouseStatus==0&&Collision(Type Mouse)&&Mouse.Left);
            MouseStatus=ID;
            While(Mouse.Left)
                If(Collision(Type Mouse))
                    Flags=4;
                Else
                    Flags=0;
                End
                Frame(100);
            End
            If(Collision(Type Mouse))
                Sound(Alternative.Snare.Dry,256,1025);
                SelectedSound=8;
            End
            Flags=0;
            MouseStatus=0;
        End
        Frame(100);
    End
End

Process Alternative_Short_Snare_Button();
Begin
    Graph=108;
    X=437;
    Y=569;
    Loop
        If(MouseStatus==0&&Collision(Type Mouse)&&Mouse.Left);
            MouseStatus=ID;
            While(Mouse.Left)
                If(Collision(Type Mouse))
                    Flags=4;
                Else
                    Flags=0;
                End
                Frame(100);
            End
            If(Collision(Type Mouse))
                Sound(Alternative.Snare.Short,256,1025);
                SelectedSound=9;
            End
            Flags=0;
            MouseStatus=0;
        End
        Frame(100);
    End
End

Process Alternative_Damped_Snare_Button();
Begin
    Graph=109;
    X=497;
    Y=569;
    Loop
        If(MouseStatus==0&&Collision(Type Mouse)&&Mouse.Left);
            MouseStatus=ID;
            While(Mouse.Left)
                If(Collision(Type Mouse))
                    Flags=4;
                Else
                    Flags=0;
                End
                Frame(100);
            End
            If(Collision(Type Mouse))
                Sound(Alternative.Snare.Damped,256,1025);
                SelectedSound=10;
            End
            Flags=0;
            MouseStatus=0;
        End
        Frame(100);
    End
End

Process Alternative_High_Tom_Button();
Begin
    Graph=110;
    X=551;
    Y=569;
    Loop
        If(MouseStatus==0&&Collision(Type Mouse)&&Mouse.Left);
            MouseStatus=ID;
            While(Mouse.Left)
                If(Collision(Type Mouse))
                    Flags=4;
                Else
                    Flags=0;
                End
                Frame(100);
            End
            If(Collision(Type Mouse))
                Sound(Alternative.Tom.High,256,1025);
                SelectedSound=11;
            End
            Flags=0;
            MouseStatus=0;
        End
        Frame(100);
    End
End

Process Alternative_Middle_Tom_Button();
Begin
    Graph=111;
    X=598;
    Y=569;
    Loop
        If(MouseStatus==0&&Collision(Type Mouse)&&Mouse.Left);
            MouseStatus=ID;
            While(Mouse.Left)
                If(Collision(Type Mouse))
                    Flags=4;
                Else
                    Flags=0;
                End
                Frame(100);
            End
            If(Collision(Type Mouse))
                Sound(Alternative.Tom.Middle,256,1025);
                SelectedSound=12;
            End
            Flags=0;
            MouseStatus=0;
        End
        Frame(100);
    End
End

Process Alternative_Low_Tom_Button();
Begin
    Graph=112;
    X=643;
    Y=569;
    Loop
        If(MouseStatus==0&&Collision(Type Mouse)&&Mouse.Left);
            MouseStatus=ID;
            While(Mouse.Left)
                If(Collision(Type Mouse))
                    Flags=4;
                Else
                    Flags=0;
                End
                Frame(100);
            End
            If(Collision(Type Mouse))
                Sound(Alternative.Tom.Low,256,1025);
                SelectedSound=13;
            End
            Flags=0;
            MouseStatus=0;
        End
        Frame(100);
    End
End

Process Alternative_FX1_Button();
Begin
    Graph=113;
    X=210;
    Y=569;
    Loop
        If(MouseStatus==0&&Collision(Type Mouse)&&Mouse.Left);
            MouseStatus=ID;
            While(Mouse.Left)
                If(Collision(Type Mouse))
                    Flags=4;
                Else
                    Flags=0;
                End
                Frame(100);
            End
            If(Collision(Type Mouse))
                Sound(Alternative.FX.#1,256,1025);
                SelectedSound=14;
            End
            Flags=0;
            MouseStatus=0;
        End
        Frame(100);
    End
End

Process Alternative_FX2_Button();
Begin
    Graph=113;
    X=227;
    Y=569;
    Loop
        If(MouseStatus==0&&Collision(Type Mouse)&&Mouse.Left);
            MouseStatus=ID;
            While(Mouse.Left)
                If(Collision(Type Mouse))
                    Flags=4;
                Else
                    Flags=0;
                End
                Frame(100);
            End
            If(Collision(Type Mouse))
                Sound(Alternative.FX.#2,256,1025);
                SelectedSound=15;
            End
            Flags=0;
            MouseStatus=0;
        End
        Frame(100);
    End
End

Process Alternative_FX3_Button();
Begin
    Graph=113;
    X=244;
    Y=569;
    Loop
        If(MouseStatus==0&&Collision(Type Mouse)&&Mouse.Left);
            MouseStatus=ID;
            While(Mouse.Left)
                If(Collision(Type Mouse))
                    Flags=4;
                Else
                    Flags=0;
                End
                Frame(100);
            End
            If(Collision(Type Mouse))
                Sound(Alternative.FX.#3,256,1025);
                SelectedSound=16;
            End
            Flags=0;
            MouseStatus=0;
        End
        Frame(100);
    End
End

Process Alternative_FX4_Button();
Begin
    Graph=113;
    X=261;
    Y=569;
    Loop
        If(MouseStatus==0&&Collision(Type Mouse)&&Mouse.Left);
            MouseStatus=ID;
            While(Mouse.Left)
                If(Collision(Type Mouse))
                    Flags=4;
                Else
                    Flags=0;
                End
                Frame(100);
            End
            If(Collision(Type Mouse))
                Sound(Alternative.FX.#4,256,1025);
                SelectedSound=17;
            End
            Flags=0;
            MouseStatus=0;
        End
        Frame(100);
    End
End

//______________________________Playing system:______________________________

Process Set_Rhythm();
Begin
    Loop
        X=Mouse.X/8;
        X*=8;
        Y=(Mouse.Y-11)/60;
        Y=(Y*60)+11;
        Switch(SelectedSound);
            Case 0:
                Graph=0;
            End
            Case 1..3:
                Graph=500;
            End
            Case 4..5:
                Graph=501;
            End
            Case 6:
                Graph=502;
            End
            Case 7..10:
                Graph=503;
            End
            Case 11..13:
                Graph=504;
            End
            Case 14..17:
                Graph=505;
            End
        End
        If(Y>491)
            Graph=0;
        End
        If(Mouse.Left&&SelectedSound<>0&&Mouse.Y<551&&MouseStatus==0)
            Put(File,Graph,X,Y);
            Switch(Y)
                Case 11:
                    Rhythm.#1[X/8]=SelectedSound;
                End
                Case 71:
                    Rhythm.#2[X/8]=SelectedSound;
                End
                Case 131:
                    Rhythm.#3[X/8]=SelectedSound;
                End
                Case 191:
                    Rhythm.#4[X/8]=SelectedSound;
                End
                Case 251:
                    Rhythm.#5[X/8]=SelectedSound;
                End
                Case 311:
                    Rhythm.#6[X/8]=SelectedSound;
                End
                Case 371:
                    Rhythm.#7[X/8]=SelectedSound;
                End
                Case 431:
                    Rhythm.#8[X/8]=SelectedSound;
                End
                Case 491:
                    Rhythm.#9[X/8]=SelectedSound;
                End
            End
        End
        If(Mouse.Right&&Mouse.Y<551)
            Put(File,801,X,Y);
            Switch(Y)
                Case 11:
                    Rhythm.#1[X/8]=0;
                End
                Case 71:
                    Rhythm.#2[X/8]=0;
                End
                Case 131:
                    Rhythm.#3[X/8]=0;
                End
                Case 191:
                    Rhythm.#4[X/8]=0;
                End
                Case 251:
                    Rhythm.#5[X/8]=0;
                End
                Case 311:
                    Rhythm.#6[X/8]=0;
                End
                Case 371:
                    Rhythm.#7[X/8]=0;
                End
                Case 431:
                    Rhythm.#8[X/8]=0;
                End
                Case 491:
                    Rhythm.#9[X/8]=0;
                End
            End
        End
        Frame(100);
    End
End

Process Play_Rhythm();
Begin
    Loop
        If(key(_Space));
            While(Key(_Space))
                Frame(100);
            End
            Playing=1;
        End
        While(Playing==1)
            Timing+=1000/Fps;
            If(Timing/Rhythm.Speed=>128)
                Timing=0;
            End
            If(Timing%Rhythm.Speed<Rhythm.Buffer)
                Play_Sound(Rhythm.#1[Timing/Rhythm.Speed]);
                Play_Sound(Rhythm.#2[Timing/Rhythm.Speed]);
                Play_Sound(Rhythm.#3[Timing/Rhythm.Speed]);
                Play_Sound(Rhythm.#4[Timing/Rhythm.Speed]);
                Play_Sound(Rhythm.#5[Timing/Rhythm.Speed]);
                Play_Sound(Rhythm.#6[Timing/Rhythm.Speed]);
                Play_Sound(Rhythm.#7[Timing/Rhythm.Speed]);
                Play_Sound(Rhythm.#8[Timing/Rhythm.Speed]);
                Play_Sound(Rhythm.#9[Timing/Rhythm.Speed]);
            End
            If(Key(_Space))
                While(Key(_Space))
                    Frame(100);
                End
                Playing=Timing=0;
            End
            Frame(100);
        End
        Frame(100);
    End
End

Process Play_Sound(Indicator);
Begin
    Switch(Indicator)
        Case 1:
            Sound(Alternative.HiHat.Closed,256,1025);
        End
        Case 2:
            Sound(Alternative.HiHat.Peddal,256,1025);
        End
        Case 3:
            Sound(Alternative.HiHat.Open,256,1025);
        End
        Case 4:
            Sound(Alternative.Crash.Normal,256,1025);
        End
        Case 5:
            Sound(Alternative.Crash.Reversed,256,1025);
        End
        Case 6:
            Sound(Alternative.Base,256,1025);
        End
        Case 7:
            Sound(Alternative.Snare.Normal,256,1025);
        End
        Case 8:
            Sound(Alternative.Snare.Dry,256,1025);
        End
        Case 9:
            Sound(Alternative.Snare.Short,256,1025);
        End
        Case 10:
            Sound(Alternative.Snare.Damped,256,1025);
        End
        Case 11:
            Sound(Alternative.Tom.High,256,1025);
        End
        Case 12:
            Sound(Alternative.Tom.Middle,256,1025);
        End
        Case 13:
            Sound(Alternative.Tom.Low,256,1025);
        End
        Case 14:
            Sound(Alternative.FX.#1,256,1025);
        End
        Case 15:
            Sound(Alternative.FX.#2,256,1025);
        End
        Case 16:
            Sound(Alternative.FX.#3,256,1025);
        End
        Case 17:
            Sound(Alternative.FX.#4,256,1025);
        End
    End
    Frame(100);
End

Process Time_Bar();
Begin
    Y=12;
    Loop
        If(Playing==1)
            Graph=802;
        Else
            Graph=0;
        End
        X=(Timing/Rhythm.Speed)*8;
        Frame(100);
    End
End