Program Tile_Edit;
Const
  TCX = 256;
  TCY = 192;
  TS  = 16;

  Def_Graph = 1;
  ScrX      = 640;
  ScrY      = 480;
  ScrSpe    = ts;
  ScrEdg    = 2;

  HTS = TS / 2;
  MSX = TCX * TS;
  MSY = TCY * TS;
Global
  Struct Map
    Struct X[256]
      Y[192];
    End
  End

  Struct MapNfo[5]
    Struct Pos[99]
      a,b,c,d;
    end
    many;
  end

  Tile; Gui;

  MouseX,MouseY;
  SelTile[2] = 1,2,3;

  Grid_Enabled = 0;
  TileFile     = "\dat\floor0.dat";
  NfoFile      = "\dat\floor0n.dat";
Begin
  Set_Mode(640480);
  Set_FPs(60,0);
  VSync = 1;

  Tile = Load_Fpg("3boft.fpg");
  Gui  = Load_Fpg("3egui.fpg");

  From x=1 to 30: From y=1 to 30:
    Map_Put(gui,5,6,x*ts-hts,y*ts-hts);
  end end

  Clear_Map();
  Tile_Pal();

  Editor();
End

Process Editor()
private
  s_key;
Begin
  Define_Region(1,000,0,480,480);
  Define_Region(2,480,0,160,480);

  Start_Scroll(0,Tile,999,0,1,0);
  Start_Scroll(1,Tile,998,0,2,0);

  Mouse.File  = Gui;
  Mouse.Graph = 1;

  Loop
    MouseX = Mouse.x + scroll[0].x0; MouseY = Mouse.y + scroll[0].y0;

    If( Mouse.X < 480)
      Mouse.Graph = 1;
      If( Mouse.Left  ) Put_Tile(mousex,mousey,seltile[0]); End
      If( Mouse.Right ) Put_Tile(Mousex,mousey,seltile[1]); End
      If( Mouse.Middle) Put_Tile(Mousex,mousey,seltile[2]); End
    Else
      Mouse.Graph = 2;
      If( Mouse.Left  ) Sel_Tile(0); End
      If( Mouse.Right ) Sel_Tile(1); End
      If( Mouse.Middle) Sel_Tile(2); End
    End

    if(mouse.x < scredg     ) scroll[0].x0-=scrspe; end
    if(mouse.x > scrx-scredg) scroll[0].x0+=scrspe; end
    if(mouse.y < scredg     ) scroll[0].y0-=scrspe; end
    if(mouse.y > scry-scredg) scroll[0].y0+=scrspe; end

    if(key(_q))
      if(mouse.left)  fill_x(mousey,seltile[0]); end
      if(mouse.right) fill_x(mousey,seltile[1]); end
    end
    if(key(_w))
      if(mouse.left)  fill_y(mousex,seltile[0]); end
      if(mouse.right) fill_y(mousex,seltile[1]); end
    end

    If(key(_s))
      if( s_key==0 )
        obj(5,mapnfo[5].many,mousex,mousey,0,0);
        mapnfo[5].many++;
      end
      s_key=1;
    else
      s_key=0;
    end

    if(key(_z)) scroll[1].y0-=ts; end
    if(key(_x)) scroll[1].y0+=ts; end

    if( key(_f1) ) Save_Tile(); End
    if( key(_f2) ) Load_Tile(); End
    If( Key(_f9) ) Draw_Tiles(); End
    if( key(_f10))
      if( grid_enabled == 0) grid_enabled = 1; else grid_enabled = 0; end
    end

    Tile_Mouse();
    If( Grid_Enabled == 1) Grid(); End

    Img(tile,seltile[0],mouse.x-10,mouse.y+30);
    Img(tile,seltile[1],mouse.x+15,mouse.y+30);
    Img(tile,seltile[2],mouse.x+02,mouse.y+50);

    Frame;
  End
End
/******************************/
/* OBJ MANIPULATION FUNCTIONS */
/******************************/
Process Obj(typ,pl,x,y,angle,set)
private
  g[5] = 7,7,7,7,7,7;
begin
  file = gui;
  graph = g[typ];
  ctype = c_scroll;

  x = x / ts * ts + hts;
  y = y / ts * ts + hts;

  mapnfo[typ].pos[pl].a = x;
  mapnfo[typ].pos[pl].b = y;
  mapnfo[typ].pos[pl].c = angle;

  loop
    if( fget_dist(x,y,mousex,mousey)<16 )
      if( key(_a)) angle = fget_angle(x,y,mousex,mousey); mapnfo[typ].pos[pl].c = angle; end
    end
    frame;
  end
end

Process Draw_Nfos()
Begin
  From x=0 to 5:
    for(y=0;y<mapnfo[x].many;y++)
      //obj(x,y,mapnfo[x].pos[y].a,mapnfo[x].pos[y].b,mapnfo[x].pos[y].c,mapnfo[x].pos[y].d);
    end
  end
End
/*******************************/
/* TILE MANIPULATION FUNCTIONS */
/*******************************/
process fill_x(y,graph)
begin
  tilec();

  from x=0 to tcx:
    put_tile(x*ts,y,graph);
  end
end

process fill_y(x,graph)
begin
  tilec();

  from y=0 to tcy:
    put_tile(x,y*ts,graph);
  end
end

Process Sel_Tile(num)
Begin
  x  = mouse.x - 480 + scroll[1].x0;
  y  = mouse.y + scroll[1].y0;
  TileC();
  X /= ts;
  Y /= ts;

  SelTile[num] = y * 10 + x + 1;
End

Process Put_Tile(x,y,graph)
begin
  TileC();

  map.X[x/ts].Y[y/ts] = Graph;
  Map_Put(Tile,999,Map.X[x/ts].Y[y/ts],x,y);
  Refresh_Scroll(0);
end

Process Grid()
Begin
  File  = Gui;
  Graph = 5;
  X     = 240;
  Y     = 240;

  Frame;
End

Process Tile_Mouse()
Begin
  File  = Gui;
  Graph = 4;

  X = Mouse.X;
  Y = Mouse.Y;
  Z = -5;

  TileC();

  Frame;
end

Process Img(file,graph,x,y) begin frame; end

Process TileC() // Tile Coordnation
Begin
  Father.X = Father.X / TS * TS + hts;
  Father.Y = Father.Y / TS * TS + hts;
End
/*****************/
/* FILE HANDLING */
/*****************/
Process Save_tile()
begin
  Save(TileFile,&map,sizeof(map));
  Save(NfoFile,&mapnfo,sizeof(mapnfo));
end

Process Load_Tile()
Begin
  Load(TileFile,&map);
  Load(NfoFile,&mapnfo);//,sizeof(mapnfo));
  Draw_Tiles();
  Draw_Nfos();
End
/**********************/
/* BUILD UP FUNCTIONS */
/**********************/
Process Draw_Tiles()
Begin
  For( x=0;x<tcx;x++ )
    For( y=0;y<tcy;y++ )
      Map_Put(Tile,999,Map.X[x].Y[y],x*ts+hts,y*ts+hts);
    End
  ENd
  Refresh_scroll(0);
End

Process Clear_Map()
Begin
  For( x=0;x<tcx;x++ )
    For( y=0;y<tcy;y++ )
      Map.X[x].Y[y] = Def_Graph;
    End
  End
  Draw_Tiles();
End

Process Tile_Pal()
Begin
  from y=1 to 84:
    from x=1 to 10:
      z++;
      map_put(tile,998,z,x*ts-hts,y*ts-hts);
    end
  End
  Refresh_scroll(1);
End