PROGRAM text1; // Example of text system for highscores etc.
// All code, gfx etc. (c) 2001 I. Price

// This is a very simple method of collecting and storing text in an array
// This program is not intended to be viewed as a complext text management
// system. Use it for entering names into a high score etc.
// This code will need to be implemented into your own.

GLOBAL
fpg;           // Graphic file
graph_number;  // The number of the graphic which the cursor is over

name[10];      // Array to store name data (max 10 characters)

BEGIN

SET_MODE(m320x200); // Lo-res graphic mode

fpg="text.fpg";     // Graphic file name

LOAD_FPG(fpg);      // Load graphic file (containing text)

z=100;              // Graphic number (text)


// Draw text on screen in a box/grid
FROM y=10 TO 224 STEP 32;
FROM x=10 TO 224 STEP 32;
IF (z<142) PUT(fpg,z,x,y);END // Show only graphics in file
z++;
END
END

move_cursor(); // Activate cursor process

END


// Cursor movement process
PROCESS move_cursor();
PRIVATE
press; // Limit keystrokes
num;   // Position number for text in name[] array

BEGIN
x=10;
y=10;
GRAPH=1; // Cursor graphic number in file
graph_number=100; // Graphic number under cursor

LOOP

// Move cursor right
IF (KEY(_RIGHT) AND press==0 AND x<200)
 x+=32;
 press=3;
 graph_number++;
END

// Move cursor left
IF (KEY(_LEFT) AND press==0 and x>10)
 x-=32;
 press=3;
 graph_number--;
END

// Move cursor up
IF (KEY(_UP) AND press==0 AND y>10)
 y-=32;
 press=3;
 graph_number-=7;
END

// Move cursor down
IF (KEY(_DOWN) AND press==0 AND y<170)
 y+=32;
 press=3;
 graph_number+=7;
END

// Enter text into array (unless on delete graphic) and show on screen
IF (KEY(_SPACE) AND press==0 AND graph_number<141)
 name[num]=graph_number; // Enter data into name[] array
 PUT(fpg,136,num*16+50,190); // Blank space
 PUT(fpg,graph_number,num*16+50,190); // Text character
 IF (num<=9) num++;END
 press=4;
END

// Delete text
IF (KEY(_SPACE) AND press==0 AND graph_number==141)
 num--;
 IF (num<0) num=0;END
 name[num]=0; // Delete text data from memory
 PUT(fpg,136,num*16+50,190);
 press=4;
END

// Clear text
IF (KEY(_C) AND press==0)
 FROM num=0 TO 10;
 PUT(fpg,136,num*16+50,190); // Delete any text on screen
 name[num]=0; // Clear name[] array of all data
 END
 num=0;
 press=4;
END

// Save text
IF (KEY(_S) AND press==0)
 SAVE("text",&name,10); // Save name[] data into a text file "text.txt"
 press=4;
END

// Load text
IF (KEY(_L) AND press==0)
 LOAD("text",&name); // Load name[] array
 FROM num=0 TO 10;
 PUT(fpg,136,num*16+50,190); // Clear any old text
 IF (name[num]>0) PUT(fpg,name[num],num*16+50,190);END // Draw name
 END
 num=0;
END

// Show text info on right of screen
DELETE_TEXT(ALL_TEXT);
WRITE(0,230,10,0,"GRAPH=");
WRITE_INT(0,280,10,0,&graph_number);
WRITE(0,230,30,0,"S - SAVE TEXT");
WRITE(0,230,40,0,"L - LOAD TEXT");
WRITE(0,230,50,0,"C - CLEAR TEXT");
WRITE(0,230,70,0,"(C) I.PRICE");

// Reduce keystrokes
IF (press>0) press--;END

FRAME;
END
END

