//Written by Peter Lafferty
//Visit http://crystal.sphosting.com/

//Demonstrates how to get the distance between two points in 3dimensional space
/*
 notes : The distance between two points p0(x0,y0,z0) and p1(x1,y1,z1)
 is the square root of ( (x1-x0)^2 + (y1-y0)^2 + (z1-z0)^2)
 ^ = to the power of
*/
PROGRAM COLLISION_IN_MODE_7;
GLOBAL
id1;
id_;
dist_;
BEGIN
 load_fpg("m7_colli.fpg");
 set_mode(m640x480);
 write(0,10,10,3,"YOU HAVE COLLIDED WITH ID: ");
 write(0,10,30,3,"PIXELS DISTANCE FROM ID  : ");
 write_int(0,180,10,3,&id_);
 write_int(0,180,30,3,&dist_);
// write_int(0,180,50,3,&fps);


 start_mode7(0,0,1,0,0,-200);
  m7.height = 600;
  m7.distance =60 ;
  m7.color = 213;
  m7.camera = id;

 x=160;
 y=280;
 angle=90000;

 enemy(100,100); enemy(300,20);  enemy(200,190);  enemy(270,100);
 enemy(10,10);   enemy(100,200); enemy(200,50);   enemy(70,170);

 player();
 LOOP
//  angle=get_angle(id1);
  IF(key(_ESC)) break; END
  FRAME;
 END
 stop_mode7(0);
 unload_fpg(0);
 let_me_alone();
END

PROCESS ENEMY(x,y)
BEGIN
ctype=c_m7;
graph=3;
LOOP
 frame;
END
END



PROCESS PLAYER()
BEGIN
ctype=c_m7;
graph=2;
x=160;
y=100;
id1=id;
loop
 id_=m7_collision(type enemy,10);
 IF(id_!=0)
  dist_=get_m7_dist(id_);

 ELSE
  dist_=0;
 END
 IF (key(_right)) x+=5; END
 IF (key(_left)) x-=5; END
 IF (key(_up)) y-=5; END
 IF (key(_down)) y+=5; END

 frame;
END

END
/*
  PROCESS m7_collision
  PARAMETERS  <process type> <distance to check for>
  RETURNS <id of process collided with or zero>

    Checks for a collision between the current process
  and all process' of the given TYPE. If a process of
  the given type is found to be within the specified
  distance its identify code is returned otherwise a 0
  is returned.

*/
PROCESS  m7_collision(id_type,dist)
PRIVATE
id_code;
holder;
BEGIN
 x=father.x;//takes fathers x and y values
 y=father.y;

 LOOP
  id_code=get_id(id_type);//gets all id_types

  IF(id_code==0)
   break;        //if none of the current id_type exist or none are within
                 // the specified distance return 0
  ELSE
   IF(get_m7_dist(id_code)<=dist)
    break;   //if current id is withing distance return its id_code
   END
  END
 END

 RETURN(id_code);

END

/*
 PROCESS get_m7_dist
 PARAMETERS <process identifying code>
 RETURNS <distance between the two process'>
  calls fget_m7_dist using fathers and id_codes values

*/
PROCESS get_m7_dist(id_code)
BEGIN
 return(fget_m7_dist(father.x,father.y,father.height,id_code.x,id_code.y,id_code.height));
END

/*
 PROCESS fget_m7_dist
 PARAMETERS <2 3d points>
 RETURNS the distance between two 3d points
 does a simple calculation and returns the answer
*/

PROCESS fget_m7_dist(x0,y0,z0,x1,y1,z1)
BEGIN
 return(sqrt(pow(x1-x0,2)+pow(y1-y0,2)+pow(z1-z0,2)));
END

