PROGRAM MAP_PLAT;
CONST
GLOBAL
 map_name="MAP018.DAT"; // Default map to load is MAP001.DAT

///////////////////////////////////////////////////////////
//This is the inforamtion stored in each map

 map_width=3840;
 map_height=2880;

 STRUCT mapy1[91]    //first layer:general background layer
  x[121];
 END
 STRUCT mapy2[91]    //second layer:used for collisions
  x[121];
 END
 STRUCT mapy3[91]    //third layer:used for animations
  x[121];
 END
 STRUCT mapy4[91]    //fourth layer:used for foreground
   x[121];
 END

 STRUCT mapy5[91]   //fifth layer:used to load process`
  STRUCT x[121];
    PROCESS_NO;
    GRAPH_NO;
    MAP;
    X_TILE;
    Y_TILE;
  END
 END

STRUCT ANIMATIONS[19]
  GRAPHICS[9];
END
///////////////////////////////////////////////////////////

//MAP NAMES
mapnames[99] =
"MAP001.DAT","MAP002.DAT","MAP003.DAT","MAP004.DAT","MAP005.DAT","MAP006.DAT","MAP007.DAT","MAP008.DAT","MAP009.DAT","MAP010.DAT",
"MAP011.DAT","MAP012.DAT","MAP013.DAT","MAP014.DAT","MAP015.DAT","MAP016.DAT","MAP017.DAT","MAP018.DAT","MAP019.DAT","MAP020.DAT",
"MAP021.DAT","MAP022.DAT","MAP023.DAT","MAP024.DAT","MAP025.DAT","MAP026.DAT","MAP027.DAT","MAP028.DAT","MAP029.DAT","MAP030.DAT",
"MAP031.DAT","MAP032.DAT","MAP033.DAT","MAP034.DAT","MAP035.DAT","MAP036.DAT","MAP037.DAT","MAP038.DAT","MAP039.DAT","MAP040.DAT",
"MAP041.DAT","MAP042.DAT","MAP043.DAT","MAP044.DAT","MAP045.DAT","MAP046.DAT","MAP047.DAT","MAP048.DAT","MAP049.DAT","MAP050.DAT",
"MAP051.DAT","MAP052.DAT","MAP053.DAT","MAP054.DAT","MAP055.DAT","MAP056.DAT","MAP057.DAT","MAP058.DAT","MAP059.DAT","MAP060.DAT",
"MAP061.DAT","MAP062.DAT","MAP063.DAT","MAP064.DAT","MAP065.DAT","MAP066.DAT","MAP067.DAT","MAP068.DAT","MAP069.DAT","MAP070.DAT",
"MAP071.DAT","MAP072.DAT","MAP073.DAT","MAP074.DAT","MAP075.DAT","MAP076.DAT","MAP077.DAT","MAP078.DAT","MAP079.DAT","MAP080.DAT",
"MAP081.DAT","MAP082.DAT","MAP083.DAT","MAP084.DAT","MAP085.DAT","MAP086.DAT","MAP087.DAT","MAP088.DAT","MAP089.DAT","MAP090.DAT",
"MAP091.DAT","MAP092.DAT","MAP093.DAT","MAP094.DAT","MAP095.DAT","MAP096.DAT","MAP097.DAT","MAP098.DAT","MAP099.DAT","MAP100.DAT";

//Used to convert colour 2 to to transparent colour
//used to make the foreground transparent
pal[255]=
   000,001,002,003,004,005,006,007,008,009,
   010,011,012,013,014,015,016,017,018,019,
   020,021,022,023,024,025,026,027,028,029,
   030,031,032,033,034,035,036,037,038,039,
   040,041,042,043,044,045,046,047,048,049,
   050,051,052,053,054,055,056,057,058,059,
   060,061,062,063,064,065,066,067,068,069,
   070,071,072,073,074,075,076,077,078,079,
   080,081,082,083,084,085,086,087,088,089,
   090,091,092,093,094,095,096,097,098,099,
   100,101,102,103,104,105,106,107,108,109,
   110,111,112,113,114,115,116,117,118,119,
   120,121,122,123,124,125,126,127,128,129,
   130,131,132,133,134,135,136,137,138,139,
   140,141,142,143,144,145,146,147,148,149,
   150,151,152,153,154,155,156,157,158,159,
   160,161,162,163,164,165,166,167,168,169,
   170,171,172,173,174,175,176,177,178,179,
   180,181,182,183,184,185,186,187,188,189,
   190,191,192,193,194,195,196,197,198,199,
   200,201,202,203,204,205,206,207,208,209,
   210,211,212,213,214,215,216,217,218,219,
   220,221,222,223,224,225,226,227,228,229,
   230,231,232,233,234,235,236,237,238,239,
   000,241,242,243,244,245,246,247,248,249,
   250,251,252,253,254,255;



file1;
LOCAL
SPEED;
on_the_ground=false;
gravity_speed;
PRIVATE
BEGIN
 set_mode(m640x480);
 file1=load_fpg("map_plat.fpg");
 map_load(map_name);

END

process map_load(name)
private
tile_x_ctr;
tile_y_ctr;
name;
file_ptr;
a;
b;

begin
fade_off();
stop_scroll(0);

load(name,&map_width);

for(a=0;a<91;a++)
 for(b=0;b<121;b++)
  switch(mapy5[a].x[b].process_no)
   case 1:
//    door((b*32+16),(a*32+16),mapy5[a].x[b].map,mapy5[a].x[b].graph_no,mapy5[a].x[b].x_tile,mapy5[a].x[b].y_tile);
   end
   case 2:

    player((b*32+16),(a*32+16));
   end
  end
 end

end
make_map();
frame;

end


process make_map()
private
x_variable=0;
x_position=0;
x_struct=0;


y_variable=0;
y_position=0;
y_struct=0;

variable1=16;
variable2=16;
a;
b;

map1;
map2;
map3;

begin
 ctype=c_scroll;
 cnumber=c_0;
 fade_on();
 variable1=16;
 for(a=0;a<90;a++)
  //y_variable=scroll[0].y0+(a*32);
  y_position=variable1;//-(y_variable%32);
  y_struct=(variable1/32)+1;
  variable2=16;
  for(b=0;b<120;b++)
   //x_variable=scroll[0].x0+(b*32);
   x_position=variable2;//-(x_variable%32);
   x_struct=(variable2/32)+1;
   map1=mapy1[y_struct].x[x_struct];
   map2=mapy2[y_struct].x[x_struct];

   if(map1!=0)
    map_put(0,901,map1,x_position,y_position);
   end
   if(map2!=0)
    map_put(0,902,map2,x_position,y_position);
   end
   variable2+=32;
  end
  variable1+=32;
 end
 start_scroll(0,0,901,0,0,0);
 refresh_scroll(0);
 frame;
end

PROCESS player(x,y)
PRIVATE
 incx;
 last_speed;
 tile;
BEGIN
 graph=101;
 ctype=c_scroll;
 scroll.camera=id;
 LOOP
  // Reads keyboard
  IF (key(_right)  AND SPEED<8)
    SPEED+=2;           // Increases speed to the right
    flags=0;
  ELSE
   IF (key(_left) AND SPEED>-8)
     flags=1;
     SPEED-=2;       // Increases speed to the left
   ELSE                // If no key is pressed
     IF(not key(_LEFT) AND not key(_RIGHT))

      IF (SPEED>0)    // Brakes to the right
       SPEED--;
      END
      IF (SPEED<0)    // Or brakes to the left
        SPEED++;
      END
     END
   END
  END

  last_speed=speed;
  IF(last_speed<>0)
   incx=last_speed/ABS(last_speed);
   WHILE(last_speed<>0)

            IF(map_get_pixel(file1,902,(x+incx),(y-2))<>73)
              IF(map_get_pixel(file1,902,(x+incx),(y-32))<>73)
               x+=incx;
              END
             END
    last_speed-=incx;
   END
  END

  IF(KEY(_CONTROL) AND on_the_ground==true)
    on_the_ground=false;
    gravity_speed=-18;
  END

  gravity();
  IF(SPEED<>0)
   graph++;
   IF(GRAPH>107)
    graph=100;
   END
  ELSE
   graph=101;
  END
  IF(NOT on_the_ground)
   graph=108;
  END
  IF(y>480)
   y=10;x=20;
  END
 IF(key(_ESC))
  BREAK;
 END
IF(on_the_ground)
 tile=mapy1[(y)/32+1].x[(x)/32+1];
 SWITCH(tile)
 CASE 898,0:
  angle=0;
 END
 CASE 899:
  IF(flags==0)
  angle=45000;
  ELSE
  angle=-45000;
  END
 END
 CASE 900;
  IF(flags==0)
  angle=-45000;
  ELSE
  angle=45000;
  END
 END
 END
ELSE
 ANGLE=0;
END
 frame;

 END //END OF LOOP
END

PROCESS gravity();
PRIVATE
 vgravity;
BEGIN
 vgravity=(father.gravity_speed+=2);
 IF(vgravity>16)
   vgravity=16;
   father.gravity_speed=16;
 END

 IF(vgravity<0)                        // If gravity is negative
   WHILE (vgravity++!=0)      // While not zero, increments it
    IF(map_get_pixel(file1,902,father.x,(father.y-24))<>252)
      father.y--;
    END
   END
 ELSE   // If gravity is zero or positive
   father.y+=vgravity;
   FROM vgravity=-16 TO 7 STEP 2;
    IF(map_get_pixel(file1,902,father.x,(father.y+vgravity))==105)
      BREAK;
    END
   END
   IF (vgravity<8)
     father.y+=vgravity;
     father.gravity_speed=0;
     father.on_the_ground=true;
   END
 END
END//END OF PROCESS



