PROGRAM SHOWMAP;
CONST
GLOBAL
 map_name="MAP001.DAT"; // Default map to load is MAP001.DAT

///////////////////////////////////////////////////////////
//This is the inforamtion stored in each map

 map_width=3840;
 map_height=2880;

 STRUCT mapy1[91]    //first layer:general background layer
  x[121];
 END
 STRUCT mapy2[91]    //second layer:used for collisions
  x[121];
 END
 STRUCT mapy3[91]    //third layer:used for animations
  x[121];
 END
 STRUCT mapy4[91]    //fourth layer:used for foreground
   x[121];
 END

 STRUCT mapy5[91]   //fifth layer:used to load process`
  STRUCT x[121];
    PROCESS_NO;
    GRAPH_NO;
    MAP;
    X_TILE;
    Y_TILE;
  END
 END

STRUCT ANIMATIONS[19]
  GRAPHICS[9];
END
///////////////////////////////////////////////////////////

//MAP NAMES
mapnames[99] =
"MAP001.DAT","MAP002.DAT","MAP003.DAT","MAP004.DAT","MAP005.DAT","MAP006.DAT","MAP007.DAT","MAP008.DAT","MAP009.DAT","MAP010.DAT",
"MAP011.DAT","MAP012.DAT","MAP013.DAT","MAP014.DAT","MAP015.DAT","MAP016.DAT","MAP017.DAT","MAP018.DAT","MAP019.DAT","MAP020.DAT",
"MAP021.DAT","MAP022.DAT","MAP023.DAT","MAP024.DAT","MAP025.DAT","MAP026.DAT","MAP027.DAT","MAP028.DAT","MAP029.DAT","MAP030.DAT",
"MAP031.DAT","MAP032.DAT","MAP033.DAT","MAP034.DAT","MAP035.DAT","MAP036.DAT","MAP037.DAT","MAP038.DAT","MAP039.DAT","MAP040.DAT",
"MAP041.DAT","MAP042.DAT","MAP043.DAT","MAP044.DAT","MAP045.DAT","MAP046.DAT","MAP047.DAT","MAP048.DAT","MAP049.DAT","MAP050.DAT",
"MAP051.DAT","MAP052.DAT","MAP053.DAT","MAP054.DAT","MAP055.DAT","MAP056.DAT","MAP057.DAT","MAP058.DAT","MAP059.DAT","MAP060.DAT",
"MAP061.DAT","MAP062.DAT","MAP063.DAT","MAP064.DAT","MAP065.DAT","MAP066.DAT","MAP067.DAT","MAP068.DAT","MAP069.DAT","MAP070.DAT",
"MAP071.DAT","MAP072.DAT","MAP073.DAT","MAP074.DAT","MAP075.DAT","MAP076.DAT","MAP077.DAT","MAP078.DAT","MAP079.DAT","MAP080.DAT",
"MAP081.DAT","MAP082.DAT","MAP083.DAT","MAP084.DAT","MAP085.DAT","MAP086.DAT","MAP087.DAT","MAP088.DAT","MAP089.DAT","MAP090.DAT",
"MAP091.DAT","MAP092.DAT","MAP093.DAT","MAP094.DAT","MAP095.DAT","MAP096.DAT","MAP097.DAT","MAP098.DAT","MAP099.DAT","MAP100.DAT";

//Used to convert colour 2 to to transparent colour
//used to make the foreground transparent
pal[255]=
   000,001,002,003,004,005,006,007,008,009,
   010,011,012,013,014,015,016,017,018,019,
   020,021,022,023,024,025,026,027,028,029,
   030,031,032,033,034,035,036,037,038,039,
   040,041,042,043,044,045,046,047,048,049,
   050,051,052,053,054,055,056,057,058,059,
   060,061,062,063,064,065,066,067,068,069,
   070,071,072,073,074,075,076,077,078,079,
   080,081,082,083,084,085,086,087,088,089,
   090,091,092,093,094,095,096,097,098,099,
   100,101,102,103,104,105,106,107,108,109,
   110,111,112,113,114,115,116,117,118,119,
   120,121,122,123,124,125,126,127,128,129,
   130,131,132,133,134,135,136,137,138,139,
   140,141,142,143,144,145,146,147,148,149,
   150,151,152,153,154,155,156,157,158,159,
   160,161,162,163,164,165,166,167,168,169,
   170,171,172,173,174,175,176,177,178,179,
   180,181,182,183,184,185,186,187,188,189,
   190,191,192,193,194,195,196,197,198,199,
   200,201,202,203,204,205,206,207,208,209,
   210,211,212,213,214,215,216,217,218,219,
   220,221,222,223,224,225,226,227,228,229,
   230,231,232,233,234,235,236,237,238,239,
   000,241,242,243,244,245,246,247,248,249,
   250,251,252,253,254,255;

map_fpg;
map_id=998;
map_id_fore=994;
global_x=0;//used when player collides with door
global_y=0;


LOCAL
hit_player=false; //used for collisions with door

PRIVATE
BEGIN
 set_mode(m640x480);

 //saves a blank map
 save("MAP000.DAT",OFFSET map_width,(sizeof(map_width)+sizeof(map_height)+sizeof(mapy1)+sizeof(mapy2)+sizeof(mapy3)+sizeof(mapy4)+sizeof(mapy5)+sizeof(animations)));

 map_fpg=load_fpg("map_edit.fpg");
 load_pal("map_edit.fpg");
 map_load(map_name);
 loop
  frame;
 end


END

PROCESS map_load(name)
PRIVATE
tile_x_ctr;
tile_y_ctr;
name;
file_ptr;
a;
b;

begin
fade_on();
stop_scroll(0);
load("MAP000.DAT",offset map_width);//clears all the structures to blank values
load(name,offset map_width);//clears all the structures to blank values

start_scroll(0,0,999,map_id,0,0);//start a blank scroll

for(a=0;a<91;a++)    //checks struct mapy4 for process to load
 for(b=0;b<121;b++)
  switch(mapy5[a].x[b].process_no)
   case 1:
    door((b*32-16),(a*32-16),mapy5[a].x[b].map,mapy5[a].x[b].graph_no,mapy5[a].x[b].x_tile,mapy5[a].x[b].y_tile);

   end
   case 2:
   player((b*32-16),(a*32-16));
   end
  end
 end

end
make_map();
make_foreground();
frame;

end


process make_map()
private
x_variable=0;
x_position=0;
x_struct=0;


y_variable=0;
y_position=0;
y_struct=0;

variable1=16;
variable2=16;
a;
b;

map1;
map2;
map3;

animation_ctr=0;
begin
 z=511;
 //graph=map_id;
 ctype=c_scroll;

loop
 move_scroll(0);
 variable1=16;
 for(a=0;a<15;a++)
  y_variable=scroll[0].y0+(a*32);
  y_position=variable1-(y_variable%32);
  y_struct=(y_variable/32)+1;
  variable2=16;
  for(b=0;b<20;b++)
   x_variable=scroll[0].x0+(b*32);
   x_position=variable2-(x_variable%32);
   x_struct=(x_variable/32)+1;
   map1=mapy1[y_struct].x[x_struct];
   map2=mapy2[y_struct].x[x_struct];
   map3=mapy3[y_struct].x[x_struct];


    map_put(0,map_id,997,x_position,y_position);
   if(map1!=0)
    map_put(0,map_id,map1,x_position,y_position);

   end
   if(map2!=0)
    map_put(0,map_id,map2,x_position,y_position);

   end
   if(map3!=0)
    map3=animations[map3-1].graphics[animation_ctr];
    map_put(0,map_id,map3,x_position,y_position);

   end
   variable2+=32;
  end
  variable1+=32;
 end
 animation_ctr++;
 if(animation_ctr>=10)
  animation_ctr=0;
 end
 refresh_scroll(0);
 frame;
end
end





process make_foreground()
private
x_variable=0;
x_position=0;
x_struct=0;


y_variable=0;
y_position=0;
y_struct=0;

variable1=16;
variable2=16;

a;
b;

map;
begin
 z=-512; //make foreground appear above everything else

 ctype=c_scroll;
 cnumber=c_0;
 graph=map_id_fore;
loop
 x=scroll[0].x0+320;
 y=scroll[0].y0+240;
 variable1=15;
 for(a=0;a<15;a++)
  y_variable=scroll[0].y0+(a*32);
  y_position=variable1-(y_variable%32);
  y_struct=(y_variable/32)+1;
  variable2=16;
  for(b=0;b<20;b++)
   x_variable=scroll[0].x0+(b*32);
   x_position=variable2-(x_variable%32);
   x_struct=(x_variable/32)+1;
   map=mapy4[y_struct].x[x_struct];
   map_put(0,map_id_fore,997,x_position,y_position);

   if(map!=0)
    map_put(0,map_id_fore,map,x_position,y_position);

   end
   variable2+=32;
  end
  variable1+=32;
 end
  convert_palette(file,graph,offset pal);

  frame;
 end
end










process player(x,y)
private
speedx;
speedy;
last_speedx;
last_speedy;
incx;
incy;
door_id;
wall;
begin
  ctype=c_scroll;
  graph=160;
  IF(global_x!=0) //global_x/y is not = to zero when the player collides with a door
   x=global_x;
   global_x=0;
  END
  IF(global_y!=0)
   y=global_y;
   global_y=0;
  END


 //move the scroll so its in the same place as the player
  if(x>320 and x<map_width-320)
   scroll[0].x0=x-304;
  end
  if(x>map_width-320)
   scroll[0].x0=map_width-640;
  end
  if(y>240 and y<map_height-240)
   scroll[0].y0=y-240;
  end
  if(y>map_height-240)
   scroll[0].y0=map_height-480;
  end


loop
  // Reads keyboard
  IF (key(_LEFT))
    speedx=-32;           // Increases speed to the right
  ELSE
   IF (key(_RIGHT))
     SPEEDx=32;       // Increases speed to the left
   ELSE                // If no key is pressed
     if(not key(_LEFT) and not key(_RIGHT))
       speedx=0;
     END
   END
  END

  IF (key(_UP))
    speedy=-32;           // Increases speed to the right
  ELSE
   IF (key(_DOWN) )
     SPEEDy=32;       // Increases speed to the left
   ELSE                // If no key is pressed
     if(not key(_UP) and not key(_DOWN))

        SPEEDy=0;
     END
   END
  END

//check for horizontal collision
  wall=mapy2[(y)/32+1].x[(x+speedx)/32+1];
  if(wall!=0)
   speedx=0;
  end


   x+=speedx;    // And if so, moves character
  if(speedx<>0 and x>304 and  x<(map_width-304))
   scroll[0].x0+=speedx;
  end

//keeps scroll in proper place
  if(x<0)x=16;end
  if(x>map_width) x=map_width-16;end

  IF(x<340)scroll[0].x0=0;END
  IF(x>(map_width-304)) scroll[0].x0=(map_width-640);END


//checks for vertical collisions

  wall=mapy2[(y+speedy)/32+1].x[(x)/32+1];
  if(wall!=0)
   speedy=0;
  end


   y+=speedy;    // And if so, moves character
   if(speedy<>0 and y>240 and  y<(map_height-240))
     scroll[0].y0+=speedy;
   end

  IF(y<0) y=16; END
  IF(y>map_height) y=map_height-16; END

  IF(y<240) scroll[0].y0=0; END
  IF(y>(map_height-240)) scroll[0].y0=(map_height-480);END


  door_id=collision(type door);
  if(door_id<>0)
   //counts to 5 before loading next map
   for(incx=0;incx<5;incx++)
    frame;
   end
    door_id.hit_player=true;
  end

 frame;
end


end

process door(x,y,num,graph,x_position,y_position)
private
x_position;
y_position;
begin
ctype=c_scroll;
cnumber=c_0;
z=513;

loop
 if(hit_player==true)
  graph=262;
  global_x=(x_position*32-16);
  global_y=(y_position*32-16);
  fade_off();
  map_load(mapnames[num-1]);
 END
 frame;

end
end
