PROGRAM colony;
GLOBAL
    speed=10;
    rot_speed=64;
    prev_mouse_x;
    prev_mouse_y;
    plrid;
    build_id;
    counter;
    sml_fnt;
    big_fnt;
    s_graphs[]=17,24,30,64,70,80,100,120;
    f_graphs[]=1, 20,56,60,78,93,115,135;
    i_graphs[]=5, 20,48,60,77,92,115,135;
    m_texts[]="Generator","Wall","Laser","90 Wall","Miner","Refiner","Armoury","House";
    clicked;
    fpg_code;
    ico_code;
    sol_code;
    bui_code;
    col_id;
    delete_all;
    new;
    menus;
    armoury_id=0;
    mseid;
    nm_trees;
    id_trees[4]=0;
    nat_code;
    STRUCT roost[8]
        x;
        y;
    END=-32,-32,0,-32,32,-32,-32,0,0,0,32,0,-32,32,0,32,32,32;
    buildnum;
    vehicnum;
    monnum;
    power=0;
    raw=0;
    metal=0;
    tankmake=0;
    people=0;
    houses=0;
    perhouse=20;
    greatx;
    greaty;
    leastx;
    leasty;
    range=200;
    mapx=1000;
    mapy=1060;
    level=1;
LOCAL
    colid;
    space[8]=0;
    armour=1000;
PRIVATE
    graph_no=0;
    n;
    pwrval;
    rawval;
    metval;
    tnkval;
    scrollspeed=40;
BEGIN
    set_mode(m640x480);
    set_fps(25,5);
    fpg_code=load_fpg("colony.fpg");
    ico_code=load_fpg("col_ico.fpg");
    nat_code=load_fpg("col_nat.fpg");
    sol_code=load_fpg("col_sol.fpg");
    bui_code=load_fpg("col_bui.fpg");
    sml_fnt=load_fnt("col_sml.fnt");
    big_fnt=load_fnt("col_big.fnt");
    col_id=ID;
    start_scroll(0,0,1,1,0,15);
    prev_mouse_x=mouse.x;
    prev_mouse_y=mouse.y;
    plrid=tank(0,0);
//    build_id=builder();
    building(-100,-100,z,0,angle,0,1);
/*    tree(-1000,-500);
    tree(-1000,-400);
    tree(-1000,-300);
    tree(-1000,-200);
    tree(-1000,-100);*/
/*    planter(5);
    FOR(n=0; n<18; n++)
        raven();
    END*/
    mouse.graph=3;
    icon(624,192,0);
    icon(624,216,1);
    icon(624,240,2);
    icon(624,264,3);
    icon(624,288,4);
    map();
    mapview();
    bar(320,450,11);
//    building(mouse.x,mouse.y,0,0,0,1,0);
    scroll.x0=-320;
    scroll.y0=-240;
    ctype=c_scroll;
    graph=3;
    scroll.camera=ID;
    write(sml_fnt,40,460,3,"Power: ");
    write(sml_fnt,130,460,3,"Raw: ");
    write(sml_fnt,220,460,3,"Metal: ");
    write(sml_fnt,310,460,3,"Tanks: ");
    write(sml_fnt,40,440,3,"People: ");
    bar(70+25,460,12);
    bar(160+25,460,12);
    bar(250+25,460,12);
    bar(340+25,460,12);
    bar(70+25,440,12);
    bar(70+75,440,12);
    bar(70+125,440,12);
    bar(70+175,440,12);


//    pwrval=write_int(sml_fnt,150,460,3,&power);
    REPEAT
/*        IF (mouse.x<2) scroll.x0-=20; END
        IF (mouse.x>638) scroll.x0+=20; END
        IF (mouse.y<2) scroll.y0-=20; END
        IF (mouse.y>478) scroll.y0+=20; END
*/
        IF (mouse.x<2 AND x>-mapx) x-=scrollspeed; END
        IF (mouse.x>638 AND x<mapx) x+=scrollspeed; END
        IF (mouse.y<2 AND y>-mapy) y-=scrollspeed; END
        IF (mouse.y>478 AND y<mapy) y+=scrollspeed; END
        move_scroll(0);
        REPEAT
/*            FOR (n=0; n<power/20; n+=2)
                blip(70+n,460,5);
            END
            FOR (n=0; n<raw/4; n+=2)
                blip(160+n,460,4);
            END
            FOR (n=0; n<metal/4; n+=2)
                blip(250+n,460,6);
            END
            FOR (n=0; n<tankmake/2; n+=2)
                blip(340+n,460,7);
            END
            FOR (n=0; n<people; n+=2)
                blip(70+n,440,8);
            END
*/
            IF(power>9) blip(70+power/20,460,5); END
            IF(raw>1) blip(160+raw/4,460,4); END
            IF(metal>1) blip(250+metal/4,460,6); END
            IF(tankmake>3) blip(340+tankmake/8,460,7); END
            IF(people>0) blip(70+people,440,8); END

            FRAME;
            IF(key(_esc)) BREAK; END
        UNTIL (NOT mouse.left)

        FRAME;
        IF (nm_trees==0 AND level<6) planter(level); level+=1; END
    UNTIL(key(_esc) OR level>5 AND monnum+nm_trees==0)
    let_me_alone();
    IF (monnum+nm_trees==0)
        write(big_fnt,320,240,4,"Well Done - you have won.");
        write(big_fnt,320,260,4,"That was 5 Waves");
        write(big_fnt,320,280,4,"from level 1 of 11.");
        write(big_fnt,320,320,4,"Expect to see another");
        write(big_fnt,320,340,4,"version soon.");
        REPEAT FRAME; UNTIL (scan_code<>0)
        exit("Thanks for playing. More levels soon.",0);

    END


END
PROCESS tank(x,y)
PRIVATE
    colided;
    xVector;
    yVector;
    tx;
    ty;
    used;
    energy;
    n;
    move;
    pidiv=8;
    fangle;
    targid;
    fire=0;
BEGIN
    vehicnum+=1;
    file=sol_code;
    size=100;
    graph=999;
//    scroll.camera=ID;
    ctype=c_scroll;
    REPEAT
/*        IF (key(_up)) advance(speed); END
        IF (key(_down)) advance(-speed); END
        IF (key(_left)) advance(speed/5); angle+=pi/32; END
        IF (key(_right)) advance(speed/5); angle-=pi/32; END*/
        IF (mouse.left AND collision(TYPE mouse)) used=1; END
        IF (mouse.left AND NOT collision(TYPE mouse)) used=0; END
        IF (mouse.right AND used) tx=scroll.x0+mouse.x; ty=scroll.y0+mouse.y; move=1; END
        angle=fget_angle(x,y,tx,ty);
        IF (move==1) advance(speed); END

        IF (x>tx-speed AND x<tx+speed AND y>ty-speed AND y<ty+speed) move=0; END
//        colid=collision(TYPE generator); IF (colid) collide(colid,file,graph,x,y,angle,ID); END
//        colid=collision(TYPE wall); IF (colid) collide(colid,file,graph,x,y,angle,ID); END
//        colid=collision(TYPE building); IF (colid) collide(colid,file,graph,x,y,angle,ID); END
        colid=collision(TYPE tank); IF (colid) collide(colid,file,graph,x,y,angle,ID); END
//        IF (collision(TYPE building)) angle+=pi/64; advance(speed); END

        FOR (n=0; n<monnum+nm_trees; n++)
            targid=0;
            targid=get_id(TYPE raven);
            IF (NOT targid) targid=get_id(TYPE tree); END
            IF (targid)
                IF (get_dist(targid)<200)
                    IF (fire==0) fire=5; shot(x,y,fget_angle(x,y,targid.x,targid.y),armour/100,100); ELSE fire-=1; END
                    BREAK;
                END
            END
        END
        angle-=pi/2;
        FRAME;
        angle+=pi/2;
    UNTIL(key(_esc))
END
PROCESS collide(colid2,file,graph,x,y,angle,tid);
PRIVATE
    colid2;
    xVector=0;
    yVector=0;
    tid;
BEGIN
    IF (x<colid2.x+1) xVector=-1; END
    IF (x>colid2.x) xVector=1; END
    IF (y<colid2.y+1) yVector=-1; END
    IF (y>colid2.y+1) yVector=1; END
    REPEAT
        x+=xVector*speed;
        y+=yVector*speed;
    UNTIL (NOT collision(colid2))
    tid.x=x;
    tid.y=y;
END


PROCESS generator(x,y,z2,flags,angle);
PRIVATE
    delay;
    z2;
BEGIN
    angle=pi/32*angle;
    size=300;
    file=load_fpg("col_bui.fpg");
    ctype=c_scroll;
    graph=17;
    delay=0;
    z=z2;
    REPEAT
        delay++;
        FRAME;
    UNTIL (delay>25 AND NOT collision(TYPE tank) OR key(_esc))
    FOR (graph=17; graph>1; graph--);
        FOR (delay=0; delay<2; delay++);
            IF (key(_esc)) BREAK; END
            FRAME;
        END
    END
    IF (build_id>0) counter=0; END
    graph=5;
    REPEAT
        graph-=1;
        IF(graph<1) graph=5; END
        FOR (delay=0; delay<2; delay++);
            IF (key(_esc)) BREAK; END
            FRAME;
        END
    UNTIL(key(_esc))
END
PROCESS wall(x,y,z2,flags,angle);
PRIVATE
    delay;
    z2;
BEGIN
    size=300;
    angle=pi/32*angle;
    file=load_fpg("col_bui.fpg");
    ctype=c_scroll;
    delay=0;
    graph=24;
    z=z2;
    REPEAT
        delay++;
        FRAME;
    UNTIL (delay>25 AND NOT collision(TYPE tank) OR key(_esc))
    FOR (graph=25; graph>20; graph--);
        FOR (delay=0; delay<2; delay++);
            IF (key(_esc)) BREAK; END
            FRAME;
        END
    END
    IF (build_id>0) counter=0; END
    graph=20;
    REPEAT
        FRAME;
    UNTIL(key(_esc))
END
PROCESS diawall(x,y,z2,flags,angle);
PRIVATE
    delay;
    z2;
BEGIN
    size=300;
    angle=pi/32*angle;
    file=load_fpg("col_bui.fpg");
    ctype=c_scroll;
    delay=0;
    graph=64;
    z=z2;
    REPEAT
        delay++;
        FRAME;
    UNTIL (delay>25 AND NOT collision(TYPE tank) OR key(_esc))
    FOR (graph=65; graph>60; graph--);
        FOR (delay=0; delay<2; delay++);
            IF (key(_esc)) BREAK; END
            FRAME;
        END
    END
    IF (build_id>0) counter=0; END
    graph=60;
    REPEAT
        FRAME;
    UNTIL(key(_esc))
END
PROCESS laser(x,y,z,flags,angle);
PRIVATE
    delay;
BEGIN
    angle=pi/32*angle;
    size=300;
    file=load_fpg("col_bui.fpg");
    ctype=c_scroll;
    graph=30;
    delay=0;
    REPEAT
        delay++;
        FRAME;
    UNTIL (delay>25 AND NOT collision(TYPE tank) OR key(_esc))
    FOR (graph=30; graph<56; graph++);
        FOR (delay=0; delay<2; delay++);
            IF (key(_esc)) BREAK; END
            FRAME;
        END
    END
    IF (build_id>0) counter=0; END
    graph=48;
    REPEAT
        graph+=1;
        IF(graph>55) graph=48; END
        FOR (delay=0; delay<2; delay++);
            IF (key(_esc)) BREAK; END
            FRAME;
        END
    UNTIL(key(_esc))
END
PROCESS miner(x,y,z,flags,angle);
PRIVATE
    delay;
BEGIN
    angle=pi/32*angle;
    size=300;
    file=load_fpg("col_bui.fpg");
    ctype=c_scroll;
    graph=70;
    delay=0;
    REPEAT
        delay++;
        FRAME;
    UNTIL (delay>25 AND NOT collision(TYPE tank) OR key(_esc))
    FOR (graph=70; graph<78; graph++);
        FOR (delay=0; delay<2; delay++);
            IF (key(_esc)) BREAK; END
            FRAME;
        END
    END
    IF (build_id>0) counter=0; END
    graph=77;
    REPEAT
        graph+=1;
        IF(graph>78) graph=77; END
        FOR (delay=0; delay<2; delay++);
            IF (key(_esc)) BREAK; END
            FRAME;
        END
    UNTIL(key(_esc))
END
PROCESS refiner(x,y,z,flags,angle);
PRIVATE
    delay;
BEGIN
    angle=pi/32*angle;
    size=300;
    file=load_fpg("col_bui.fpg");
    ctype=c_scroll;
    graph=80;
    delay=0;
    REPEAT
        delay++;
        FRAME;
    UNTIL (delay>25 AND NOT collision(TYPE tank) OR key(_esc))
    FOR (graph=80; graph<93; graph++);
        FOR (delay=0; delay<2; delay++);
            IF (key(_esc)) BREAK; END
            FRAME;
        END
    END
    IF (build_id>0) counter=0; END
    graph=91;
    REPEAT
        graph+=1;
        IF(graph>93) graph=91; END
        FOR (delay=0; delay<2; delay++);
            IF (key(_esc)) BREAK; END
            FRAME;
        END
    UNTIL(key(_esc))
END
PROCESS building(x,y,z,flags,angle,active,code);
PRIVATE
    delay;
    active;
    finish;
    s_graph;
    f_graph;
    i_graph;
    targid;
    n;
    fire;
    wait;
    peopleowed;
    time;
BEGIN
    buildnum+=1;
    code-=1;
    angle=pi/32*angle;
    size=200;
    file=bui_code;
    ctype=c_scroll;
    graph=s_graphs[code];
    delay=0;
    s_graph=s_graphs[code];
    f_graph=f_graphs[code];
    i_graph=i_graphs[code];
    IF (active==0) REPEAT delay++; FRAME; UNTIL (delay>25 AND NOT collision(TYPE tank) OR key(_esc)) END
    IF (active==1) REPEAT delay++; x=scroll.x0+mouse.x; y=scroll.y0+mouse.y; IF (new>0 AND delay>3) finish=1; END IF (mouse.right) finish=1; END FRAME; UNTIL (((NOT collision(TYPE building)) AND (NOT collision(TYPE tank) AND mouse.left AND delay>25 AND x>leastx AND x<greatx AND y>leasty AND y<greaty) OR key(_esc) OR finish==1)) clicked=0; END
    IF (s_graph<f_graph AND finish==0) FOR (graph=s_graph; graph<f_graph; graph++); FOR (delay=0; delay<2; delay++); IF (key(_esc) OR new>0) finish=1; BREAK; BREAK; END FRAME; END END END
    IF (s_graph>f_graph AND finish==0) FOR (graph=s_graph; graph>f_graph; graph--); FOR (delay=0; delay<2; delay++); IF (key(_esc) OR new>0) finish=1; BREAK; BREAK; END FRAME; END END END
    IF (build_id>0) counter=0; END
    graph=i_graph;
    IF (code==6) armoury_id=ID; END
    IF (x-range<leastx) leastx=x-range; END
    IF (x+range>greatx) greatx=x+range; END
    IF (y-range<leasty) leasty=y-range; END
    IF (y+range>greaty) greaty=y+range; END
    IF (code==7) houses+=1; END
    REPEAT
        IF (time==0 AND peopleowed>0) people+=1; peopleowed-=1; IF (peopleowed>0) time=1; END END
        IF (i_graph<f_graph) graph+=1; END
        IF (i_graph>f_graph) graph-=1; END
        IF (i_graph>f_graph AND graph<f_graph) graph=i_graph; END
        IF (i_graph<f_graph AND graph>f_graph) graph=i_graph; END
        IF (collision(TYPE tank)) flags=4; ELSE flags=0; END
        FOR (delay=0; delay<2; delay++);
            IF (wait==0)
                wait=1;
                IF (code==0 AND power<1000) power+=5; END
                IF (code==2 AND power>5)
                    FOR (n=0; n<monnum+nm_trees; n++)
                        targid=0;
                        targid=get_id(TYPE raven);
                        IF (NOT targid) targid=get_id(TYPE tree); END
                        IF (targid)
                            IF (get_dist(targid)<100)
                                power-=5; shot(x,y-20,fget_angle(x,y-20,targid.x,targid.y),armour/100,50);
                                BREAK;
                            END
                        END
                    END
                    wait=2;
                END
                IF (code==4 AND power>10 AND people>1 AND raw<200) raw+=1; power-=10; wait=5; people-=1; time=1; END
                IF (code==5 AND power>20 AND raw>2 AND people>2 AND metal<200) raw-=2; power-=20; metal+=2; wait=10; people-=2; time=1; END
                IF (code==6 AND power>40 AND metal>20 AND people>5 AND tankmake<400) power-=40; metal-=20; tankmake+=1; wait=20; people-=5; time=1; END
                IF (code==7 AND power>10 AND people<houses*perhouse) power-=10; people+=1; wait=10; END
//"Generator","Wall","Laser","90 Wall","Miner","Refiner","Armoury"
                IF (key(_esc) OR finish) BREAK; END

            END
            wait-=1;
            IF (time>0) time-=1; END
            FRAME;
        END
    UNTIL(key(_esc) OR finish)
END



PROCESS builder();
PRIVATE
    build_num;
//Diagonal: x-=51, y+=13;
//     number[10]=   1,    2,    3,    4,    5;
    cur_types[10]=   1,    2,    2,    3,    6;
           xs[10]=   0,  -51, -102, -120,  -85;
           ys[10]=-100,  -87,  -74,  -58,  -58;
         flag[10]=   0,    0,    0,    0,    0;
       angles[10]=   0,    0,    0,    0,    1;
           zs[10]=   5,    5,    5,    3,    4;
    total_build=5;
    cur_type;
BEGIN
    build_num=0;
    REPEAT
        FRAME;
        counter++;
        IF (counter==10)
            x=xs[build_num];
            y=ys[build_num];
            z=zs[build_num];
            flags=flag[build_num];
            angle=angles[build_num];
            cur_type=cur_types[build_num];
            IF (cur_type==1) building(x,y,z,flags,angle,0,1); END
//            IF (cur_type==1) generator(x,y,z,flags,angle); END
            IF (cur_type==2) wall(x,y,z,flags,angle); END
            IF (cur_type==3) diawall(x,y,z,flags,angle); END
            IF (cur_type==4) laser(x,y,z,flags,angle); END
            IF (cur_type==5) miner(x,y,z,flags,angle); END
            IF (cur_type==6) refiner(x,y,z,flags,angle); END
            build_num++;
        END
    UNTIL (build_num>total_build OR key(_esc))
END

PROCESS icon(x,y,num)
PRIVATE
    num;
BEGIN
    file=ico_code;
    graph=num*2+1;
    size=200;
    REPEAT
        IF (collision(TYPE mouse)) graph=num*2+2; ELSE graph=num*2+1; END
        IF (collision(TYPE mouse) AND mouse.left)
            IF (num==0)
                menu(x-48,y-10,1);
                menu(x-48,y,5);
                menu(x-48,y+10,6);
                menu(x-48,y+20,7);
            END
            IF (num==1)
                menu(x-48,y+30,8);
            END
            IF (num==2)
                menu(x-48,y-10,2);
                menu(x-48,y,4);
                menu(x-48,y+10,3);
            END
            IF (num==3)
                IF (armoury_id>0 AND tankmake>3) tank(armoury_id.x+5,armoury_id.y-5); tankmake-=4; END
            END
            IF (num==4)
            END

            REPEAT FRAME; UNTIL (NOT mouse.left)
            clicked=1;
        END
        IF (delete_all>0) delete_all--; END
        IF (clicked>0) clicked++; END
        IF (mouse.left AND clicked>25) delete_all=1; clicked=0; END
        FRAME;
    UNTIL(key(_esc))
END

PROCESS menu(x,y,code)
PRIVATE
    code;
    used;
    txt_cd;
BEGIN
    menus+=1;
    file=ico_code;
    graph=20;
    size=150;
    txt_cd=write(sml_fnt,x,y,4,m_texts[code-1]);
    REPEAT
        IF (collision(TYPE mouse)) graph=21; ELSE graph=20; END
        IF (mouse.left AND collision(TYPE mouse)) building(x,y,z,flags,angle,1,code); used=1; new=menus; END
    FRAME;
    UNTIL(used==1 OR delete_all>0 OR key(_esc) OR new>0)
    delete_text(txt_cd);
    new-=1;
    menus-=1;
END

PROCESS tree(x,y)
PRIVATE
    a;
    f;
BEGIN
    FOR (a=0; a<nm_trees; a++)
        IF(id_trees[a]==0) id_trees[a]=ID; BREAK; END
    END
    file=nat_code;
    graph=1;
    ctype=c_scroll;
    REPEAT
        IF (collision(TYPE shot)) armour-=10; END
        FRAME;
    UNTIL (key(_esc) OR armour<1)
    nm_trees-=1;
END

PROCESS raven()
PRIVATE
    a;
    b;
    treeid=0;
    treesp;
    treenm;
    targid;
    c;
    rannum;
    energy=200;
    health;
    spd=10;
    n;
    id_tree;
BEGIN
    monnum+=1;
    FOR (a=0; a<nm_trees AND treeid==0; a++)
        id_tree=get_id(TYPE tree);
        FOR (b=0; b<9; b++)
            IF (id_trees[a]<>0)
                IF (id_tree.space[b]==0)
                    id_tree.space[b]=ID;
                    treeid=id_tree;
                    treesp=b;
                    treenm=a;
                    BREAK;
                    BREAK;
                    BREAK;
                    BREAK;
                END
            END
        END
    END
    IF (treeid==0) signal(ID,s_kill); END
    file=nat_code;
    graph=2;
    ctype=c_scroll;
    x=treeid.x+roost[treesp].x;
    y=treeid.y+roost[treesp].y;
    FOR (n=0; n<500; n++)
        FRAME;
    END
    REPEAT
        n=rand(0,1);
        IF (n) rannum=rand(1,buildnum); ELSE rannum=rand(1,vehicnum); END
        FOR (c=0; c<rannum; c++)
            IF (n)
                targid=get_id(TYPE building);
            ELSE
                targid=get_id(TYPE tank);
            END
        END
        REPEAT
            angle=fget_angle(x,y,targid.x,targid.y);
            advance(spd);
            IF (collision(TYPE building)==targid)
                targid.armour-=spd;
                spd=-spd;
            ELSE
                spd=abs(spd);
            END
            energy-=1;
            IF (collision(TYPE shot)) energy-=1; END
            FRAME;
        UNTIL (energy<10 OR key(_esc))
        spd=abs(spd);
        REPEAT
            angle=fget_angle(x,y,treeid.x+roost[treesp].x,treeid.y+roost[treesp].y);
            advance(spd);
            IF (collision(TYPE shot)) energy-=1; END
            FRAME;
        UNTIL (collision(TYPE tree)==treeid OR energy<1 OR key(_esc))
        IF (energy>0)
            FOR (energy; energy<200; energy+=2)
                FRAME;
            END
        END
    UNTIL (energy<1 OR key(_esc))
    monnum-=1;
END

PROCESS shot(x,y,angle,spd,max)
PRIVATE
    max;
    dis;
BEGIN
    file=sol_code;
    graph=900;
    size=50;
    ctype=c_scroll;
    REPEAT
        dis+=4;
        advance(speed*2);
        angle-=pi/2;
        FRAME;
        angle+=pi/2;
    UNTIL (dis>max OR collision(TYPE tree) OR collision(TYPE raven))
    FRAME;
    FRAME;
END

PROCESS blip(x,y,graph)
BEGIN
    size=50;
    FRAME;
    FRAME;
END

PROCESS planter(num)
PRIVATE
    num;
    n;
BEGIN
    nm_trees=num;
    FOR (n=0; n<num; n++)
        x=rand(-500,500);
        y=rand(-500,500);
        IF(x>0) x+=500; ELSE x-=500; END
        IF(y>0) y+=500; ELSE y-=500; END
        tree(x,y);
    END
    FOR (n=0; n<num*8; n++)
        raven();
    END
END

PROCESS map()
BEGIN
    x=590;
    y=50;
    graph=10;
    REPEAT
        FRAME;
    UNTIL(key(_esc))
END
PROCESS mapview()
BEGIN
    graph=9;
    size=100;
    REPEAT
        x=col_id.x/30+590;
        y=col_id.y/30+50;
        FRAME;
    UNTIL(key(_esc))
    exit("Thanks for playing.",0);
END
PROCESS bar(x,y,graph)
BEGIN
    REPEAT
        FRAME;
    UNTIL(key(_esc))
END