// Me Against the Universum
// (c) Futgiz
// 16.01.2001 - 17.01.2001
Program Me_Against_The_Universum;
Const
   Version   = "0.0.0.2";

   All_C     = C_Scroll;        // Screen type

   Max_Units = 999;             // Maximum unit count, not needed!
Global
   /* Graphic files, FPG */
   Ship_Graphics;            // Has all the unit graphics
   Gui_Graphics;             // Has all the gui graphics
   Terrain_Graphics;         // Has all the terrain graphics
   Effect_Graphics;          // Has all the "special" effect graphics

   Ship_Graphs[1]=1,2;       // Graphics indicating for everyship
   Ship_Energy[1]=60,180;    // All ships energys
   Ship_Move_Speed[1]=4,3;   // Move speed for all ships

   Building_Graph[1]=300,301;   // Building graphics
   Building_Energy[1]=350,400;  // Building energys

   Next_Point = 0;     // Needed for destination signs

   Ship_Collision;     // Indicator for, has mouse collided with a ship
   Mouse_Scroll;       // Mouse position in scroll, id

   Scroll_Speed = 10;  // Scroll speed
Local
   Typex; Destination;
Begin
   /* Loads graphics */
   Ship_Graphics    = Load_Fpg("Ship.fpg");
   Gui_Graphics     = Load_Fpg("Gui.fpg");
   Terrain_Graphics = Load_Fpg("Terrain.fpg");
   Effect_Graphics  = Load_Fpg("Effect.fpg");
  
   /* Runs test game */
   Load_Test_Game();
End

Process Load_Test_Game()
Private
   X1,Y1;
Begin
   X = 400; Y = 300;

   Set_Mode(m800x600);                // Sets mode to 800x600

   Mouse.File  = Gui_graphics;        // Mouse graphics are on GUI graphics
   Mouse.Graph = 1;                   // Mouse graph from GUI graphics
   Mouse_();                          // Another mouse process, just for spare couple of lines
   Mouse_Scroll = Mouse_Scroll_();    // Mouse position in scroll

   Start_Scroll(0,Terrain_Graphics,1,1,0,8);  // Begins scroll
   Scroll.Camera = ID;                        // Puts scroll camera to ID

   Ship(0,400,300,next_point); next_point++;  // Creates one ship
   Ship(0,400,400,next_point); next_point++;  // Creates another ship

   Loop
      /* If mouse thats edges of screen it will scroll there */
      If(Mouse.X < 30  and X > 400)  X -= Scroll_Speed; End
      If(Mouse.X > 770 and X < 1648) X += Scroll_Speed; End
      If(Mouse.Y < 30  and Y > 300)  Y -= Scroll_Speed; End
      If(Mouse.Y > 570 and Y < 1748) Y += Scroll_Speed; End

      /* Deletes all text from screen */
      Delete_Text(All_Text);
      Frame;
   End
End

Process Mouse_()
/* This process is only for detecting collision between different */
/* types of processes. (Creates also an "shadow" to mouse)        */
Begin
   File  = Mouse.File;
   Graph = Mouse.Graph;

   Loop
      /* If collision with a ship, puts SHIP_COLLISION = 1, else not! */
      If(Collision(Type Ship)) 
         Ship_Collision = 1;
      Else
         Ship_Collision = 0;
      End

      /* Takes X and Y positions from mouse */
      X=Mouse.X; Y=Mouse.Y;
      Frame;
   End
End

Process Mouse_Scroll_()
/* This process is for detecting mouse position in scroll.   */
/* Not needed, but with this you also spare couple of lines. */ 
Begin
   Loop X=Mouse.X+Scroll.X0; Y = Mouse.Y+Scroll.y0; Frame; END
End

/* Building process, does anything, so dont initialize this */
/* if you havent made it ready! Complete it your self, look */
/* at the ship process and make it by that if you dont find */
/* any other way.                                           */
Process Building(Typex,x,y)
Private
   Select;     // Indicator for has this ship been selected

   Energy;     // Ships energy
Begin
   File  = Ship_Graphics;         // Graphics from SHIP graphics
   Graph = Building_Graph[Typex]; // Graph from Building_Graph table
   CType = All_C;                 // Screen type from CONSTS
   Size  = 90;                    // Size is 90%, ?

   Energy = Building_Energy[TypeX]; // Energy from Building_Energy table

   Loop
      If(Collision(Type Mouse)) // If collides with mouse..
         Flags = 4;             // ..makes it trans by flags 4..
         If(Mouse.Left)         // ..if mouse left button pressed..
            Select = 1;         // ..puts it selected..
         End
      Else                      // If aint collision with mouse..
         Flags = 0;             // ..makes it normal by flags 0..
         If(Mouse.Right)        // ..if mouse right button pressed..
            Select = 0;         // ..unselects building..
         End
      End
      Frame;                     // Draws this!
   End
End

/* TYPEX indicates what type this ship is.          */
/* X and Y are positions.                           */
/* DESTINATION is for destination point for moving. */
Process Ship(Typex,x,y,destination)
Private
   Select;         // Indicates has this been selected
   Move;           // Move order given?
   Move_Away;      // Move away order given?

   Move_Speed;     // Move speed
   Energy;      Energy_Text,Energy_Int; // Energy information

   Dest_Angle;         // Destination angle, not actually needed.
   Dest_Point;         // Destination point ID
   Killed_Dest_Point;  // Has destination point been killed?
Begin
   File  = Ship_Graphics;       // Graphics from SHIP(unit) GRAPHICS
   Graph = Ship_Graphs[Typex];  // Graph from SHIP_GRAPHS table
   CType = All_C;               
   Size  = 90;                  // Size 90% of original, why? Put 100!

   Move_Speed = Ship_Move_Speed[Typex];  // Move speed from a table  
   Energy     = Ship_Energy[Typex];      // Energy from a table

   Loop
      If(Collision(Type Mouse)) // If collision with mouse..
         Flags = 4;             // Makes it trans..
         /* Selects unit */
         If(Mouse.left)         // If mouse left..
            Select = 1;         // Selects unit..
         End
      Else                      // Else if not collision with mouse..
         Flags = 0;             // Makes it normal..
         /* Unselects unit */
         If(Mouse.right)        // If mouse right.. 
            Select = 0;         // Unselects unit..
         End
         /* Gives move order */
         /* If mouse left button and this is selected and no collision with other ships or this.. */
         If(Mouse.left and Select == 1 and Ship_Collision == 0)
            Signal(Dest_Point,S_Kill);            // Kills Dest_Point signal
            /* Creates Destination_Point under Dest_Point */
            Dest_Point = Destination_Point(Mouse_Scroll.X,Mouse_Scroll.Y);
            Dest_Angle = Get_Angle(Dest_Point);   // Gets dest_angle from dest_point
            Move              = 1;                // Gives move order
            Killed_Dest_Point = 0;                // Dest_point is not killed!
         End
      End
      /* Moving */
      If(Move == 1)                           /* If move order given..                  */
         Dest_Angle = Get_Angle(Dest_Point);  /* Dest_Angle from Dest_Point             */
         Angle      = Dest_Angle;             /* Angle from dest_point(this is stupid!) */
         Advance(Move_Speed);                 /* Moves this forward by move_speed       */
      End

      /* If Distance between me and destination point is less than 10 and */
      /* dest_point hasnt been killed then..                              */
      If(Get_Dist(Dest_Point) < 10 and Killed_Dest_Point == 0)
         If(Dest_Point.Size > 0)    // If Dest_Point size is more than 0..
            Dest_Point.Size -= 3;   // ..Decrease it by 3..
         Else                       // ..Or else if it is less than 0..
            Killed_Dest_Point = 1;  // Destination point killed!
            Move_Away         = 0;  // Move away order..HELL NO!
         End
         Move = 0;                  // "Dont Move" order!
      End
      /* Moves away if doing nothing */
      /* If collision with another ship and not have move order or */
      /* move away order than..                                    */
      If(Collision(Type SHiP) and Move == 0 and Move_Away == 0)
         Signal(Dest_Point, S_Kill);          // ..we will kill Dest_Point..
         /* ..and born another destination_point, called dest_point to randomized place.. */
         Dest_Point = Destination_Point(X+Rand(-100,100),Y+Rand(-100,100));
         Dest_Angle = Get_Angle(Dest_Point);  // ..and give dest_angle new value, from dest_point
         Move              = 1;               // ..move order given..
         Killed_Dest_Point = 0;               // ..destination point is alive(!)..
         Move_Away         = 1;               // ..and lets give move away order too!
      End
      /* Shows selection sign & information */
      If(Select == 1)          // If selected..
         Selection_Sign(x,y);  // ..Draw selection sign!..
         /* ..and some information, about how we going! */
         /*** x-25-scroll.x0 is for that we need position in scroll from this */
         /*** object which is in scroll, -scroll.x0 does that!                */
         Energy_Text = Write(    0,x-25-Scroll.X0,y-20-Scroll.Y0,0, "E:");
         Energy_Int  = Write_Int(0,x-10-Scroll.X0,y-20-Scroll.Y0,0, &Energy);
      End
      Frame;
   End
End

/* This process aint in loop, by this way we spare couple of lines too! */
Process Selection_Sign(x,y)
Begin
   File  = Gui_Graphics; // File from GUI graphics
   Graph = 2;            // Second graph
   Flags = 4;            // Transperant
   Z     = 100;          // Z 100, ships Z is 0 by default, so this is lower than ship
   CType = All_C;        // Screen type
   Size  = 60;           // Size 60%, keep it!

   Frame;                // Draws this!
End

Process Destination_Point(x,y)
Begin
   CType = All_C;         // Screen type
   File  = Gui_Graphics;  // Graphic file, GUI graphics
   Graph = 2;             // Second graphic from file
   Flags = 4;             // Transperance by flags
   Z     = 100;           // Z 100, ships Z is 0 by default, higher value means lower on game
   Size  = 50;            // Size is 50%, keep that!

   /* Loops this, and "animates" by increasing angle by 8 (8000/1000)   */
   /* and if size is lower than 0 than stops loop, and nothing happends */
   /* after that, it will kill him!                                     */
   Loop Angle += 8000; If(Size < 0) Break; End Frame; End
End

/* This source is from my propably failured try of making an RTS, found it from my  */
/* hard disk and because of increasen need of tutorials in div-arena i think why    */
/* would put some(!) comments what here reads and give it as a tutorial!            */
/*                                                                                  */
/* Hope you learned something of it, i understand it pretty good actually still,    */
/* so i think it is also easy to understand from you! You may use any parts of this */
/* code or the hole code in your games/creations, i would appriciate a mention on   */
/* the credits screen still.                                                        */
/*                                                                                  */
/* Futgiz                                                                           */
/* bloohhound@artic.net                                                             */
/* http://www.futgiz.cjb.net                                                        */ 