
 //
 //                 CAR PHYSICS DEMO V1.0 beta 1
 //
 //      Program code and all graphics by Mike Hawkins 2001
 //
 //             EMAIL mike@mortuary69.freeserve.co.uk
 //
 //  This program code may be freely modified and used (I would
 //  appriciate a mention on the credits screen) but the author
 //  retains copyright over all graphics distributed with this
 //  program. They may not be modified or used without express
 //  permission from the author.
 //

 PROGRAM car;

 GLOBAL

     id_fpgCAR;
     driver;            // Male=7 Female=27

     carbody;           // Carbody graph (2,3,4,5)
     body;              // Driver body graph (-1,0,1)
     fwangle=0;         // Front wheel angle (-6 TO 6)
     head_dir=0;        // Required head direction (-8 TO 8)
     head_spd=10;       // Speed at which head turns (1+ (1=Fast))
     fwframe=0;         // Front wheel frame (0 TO 3)
     mhead_del=10;      // Move head delay counter (0 TO head_spd)
     hangle=0;          // Current head direction
     lockhead=FALSE;    // Lock head in position (Prevent return to front)


 PRIVATE

     option;

 BEGIN

     set_mode(m320x200);
     load_pal("car2.pal");
     write(0,160,50,4,"CAR PHYSICS DEMO V1.0 beta 1");
     write(0,160,70,4,"BY Mike Hawkins");
     write(0,160,90,4,"Select screen res");
     write(0,160,110,4,"PRESS 1 for   640x480");
     write(0,160,120,4,"PRESS 2 for   800x600");
     write(0,160,130,4,"PRESS 3 for  1024x768");
     LOOP
        IF (key(_1))
            option=0;
            BREAK;
        END
        IF (key(_2))
            option=1;
            BREAK;
        END
        IF (key(_3))
            option=3;
            BREAK;
        END
        FRAME;
     END
     delete_text(all_text);
     write(0,160,50,4,"CONTROLS");
     write(0,160,80,4,"Use cursor left/right to steer");
     write(0,160,90,4,"A=Forward gear");
     write(0,160,100,4,"Z=Reverse gear");
     write(0,160,110,4,"CONTROL=Accelerate");
     write(0,160,120,4,"ALT=Brake");
     write(0,160,190,4,"PRESS M FOR MALE OR F FOR FEMALE DRIVER");
     driver=7;
     REPEAT
        FRAME;
        driver+=20*(key(_F));
     UNTIL (key(_M) OR key(_F))
     delete_text(all_text);

     SWITCH(option)
            CASE 0;
                 set_mode(m640x480);
                 x=320;
                 y=240;
            END
            CASE 1;
                 set_mode(m800x600);
                 x=400;
                 y=300;
            END
            CASE 2;
                 set_mode(m1024x768);
                 x=512;
                 y=384;
            END
     END
     set_fps(25,0);
     id_fpgCAR=load_fpg("car2.fpg");
     carcontrol(x,y);
     WHILE (NOT key(_ESC))
            FRAME;
     END

 END




 PROCESS carcontrol(x,y)

 PRIVATE

     cardir=1;          // Car direction (1=Forward -1=Reverse)
     carspd=0;          // Car speed (0 TO 24)
     breakforce=0;      // Car break (0 TO -24)
     movecar;           // Car advance value

 BEGIN

     angle=+90000;
     LOOP

        cardir-=2*(cardir==1 AND key(_Z));       // Select reverse gear ?
        cardir+=2*(cardir==-1 AND key(_A));      // Select forward gear ?
        carbody=2+2*(cardir==-1);                // Carbody=reverse lights on
        IF (key(_CONTROL))                       // Accelerate key pressed?
            carspd+=(carspd<24);                 // Accelerate
        ELSE
            carspd-=(carspd>0);                  // Decelerate
        END
        IF (key(_ALT))                           // Brake key pressed? if so
            breakforce-=(breakforce>-24);        // increase braking force and
            carbody++;                           // carbody=brake lights on
        ELSE
            breakforce+=(breakforce<0);          // else reduce brake force
        END
        IF (key(_LEFT))                          // Is steering left pressed
            body=-1;                             // If so,show driver steer left
            fwangle-=(fwangle>-6);               // front wheels angle to left
        ELSE
           IF (key(_RIGHT))                      // Is steering right pressed
               body=1;                           // If so,show driver steer right
               fwangle+=(fwangle<6);             // front wheels angle to right
           ELSE
               body=0;                           // If not steering left/right
               fwangle+=(fwangle<0)-(fwangle>0); // show driver normal and
           END                                   // allow front wheels to centre
        END
        IF (carspd>0)                            // If car in motion
            IF (cardir==1)                       // and car in forward gear
                angle-=250*(fwangle*(carspd/3)); // rotate car clockwise
            ELSE                                 // or for reverse gear
                angle+=250*(fwangle*(carspd/3)); // rotate car anti-clockwise
            END
            head_dir=fwangle;                    // Set head target to fwangle
            head_spd=4;                          // and head turn speed
        END
        movecar=carspd+breakforce;               // Forward drive
        IF (movecar>0)                           // If move car>0
            IF (cardir==1)                       // and in forward gear
                advance(movecar);                // move car forward
            ELSE
                advance(-movecar);               // else backwards
            END
            fwframe=(fwframe+1) MOD 3;           // Front wheel frame delay
        END
        buildcar(x,y,angle-90000);               // Build car graph frame
        FRAME;

    END

 END


 PROCESS buildcar(x,y,angle)

 BEGIN

     file=id_fpgCAR;
     graph=1;                                    // Build car frame to graph 1
     IF (mhead_del==0)                           // If head delay 0
         mhead_del=head_spd;                     // reset it to current speed
         IF (hangle==head_dir AND rand(1,5)==3)  // If head angle=required
             head_dir=0;                         // head angle set driver to
             head_spd=rand(2,10);                // face front again at random
         END                                     // speed
         hangle+=(hangle<head_dir);              // else move head in
         hangle-=(hangle>head_dir);              // desired direction
     ELSE
         mhead_del--;                            // If head delay<>0 ...
     END
     carshadow(x,y+24,angle);                    // Display drop shadow
     wheels(x,y,angle);                          // and wheels
     map_put(id_fpgCAR,1,carbody,50,40);         // Copy carbody to blank
     map_put(id_fpgCAR,1,driver+body,66,109);    // copy drivers body to blank
     map_xput(id_fpgCAR,1,driver+10+hangle,70,123,0,100,0); // put in head
     map_put(id_fpgCAR,1,46,50,113);             // car roof framework
     map_xput(id_fpgCAR,1,47,50,88,0,100,4);     // and windscreen
     FRAME;

 END

 PROCESS carshadow(x,y,angle)

 BEGIN

     graph=100;
     z=100;
     flags=4;
     FRAME;

 END

 PROCESS wheels(x,y,angle)

 BEGIN

     graph=72+(fwangle*4)+fwframe;               // Show car wheels
     z=50;
     FRAME;

 END


