//**************************************
// TITLE  : SPACE ODDITY
// AUTHOR : G Martin
// January: 2001
// Version: Alpha
//**************************************
PROGRAM Oddity;

CONST

 MAX_WAVES   =  2;
 MAX_INWAVE  =  8;
 NORMAL_SHOT =  1;
 NORMAL_SHOTG=  5;
 HOMING_SHOT =  2;
 HOMING_SHOTG=  32;
 BOSS_SHOT   =  3;
 NO_ANGLE    =  0;


GLOBAL

//**************************************
// structures for high score tables
// and standard waves
//**************************************

 STRUCT HighScores
  Name[10];
  Score[10];
 END =
  10 DUP("",0);

 STRUCT Boss[2]
  YCord;
  XCord;
  Graphic1;
  Graphic2;
  Score;
  Power;
 END =
  010,010,200,201,100,15,
  005,700,202,203,100,20,
  020,010,200,201,100,25;

 STRUCT LevelWaves[2]
  XCORD[7];
  YCORD[7];
  GRAPHICCODE[7];
  VALUE[7];
 END =

    100,300,500,700, // xcords   (0,1)
    150,350,550,750, // xcords   (0,2)

    070,070,070,070, // ycords   (0,1)
    140,140,140,140, // ycords   (0,2)

    006,006,006,006, // graphics (0,1)
    006,006,006,006, // graphics (0,2)

    010,010,010,010, // value    (0,1)
    010,010,010,010, // value    (0,2)

    150,350,550,750, // xcords   (0,1)
    100,300,500,700, // xcords   (0,2)

    070,070,070,070, // ycords   (0,1)
    140,140,140,140, // ycords   (0,2)

    007,007,007,007, // graphics (0,1)
    007,007,007,007, // graphics (0,2)

    010,010,010,010, // value    (0,1)
    010,010,010,010, // value    (0,2)

    100,300,500,700, // xcords   (0,1)
    150,350,550,750, // xcords   (0,2)

    070,070,070,070, // ycords   (0,1)
    140,140,140,140, // ycords   (0,2)

    018,018,018,018, // graphics (0,1)
    018,018,018,018, // graphics (0,2)

    015,015,015,015, // value    (0,1)
    010,015,010,015; // value    (0,2)



//**************************************
// gobal variables
//**************************************

 CurrentScore=0;
 Missile_flag;
 EnemyShipScoreValue;
 Lives;
 Wave=0;
 Wave_Load;
 StartNextWave=1;
 TotalKilledInWave;

 ShotID;
 ScoreID;
 EnemyShotID;
 EnemyExplosion;
 EnemyLaser;
 LivesID;
 GameGraphicsID;
 HomeMissleSound;
 BossPower;
 BossVoice;
 BossLevel;
 BossHit;

 HomeCraftID;
 HomeCraftLaser;
 HomeCraftKilledID;
 HomeCraftType=1;
 HomeCraftExplosion;
 HomeCraftPickUp;
 CraftIsImmune;


//**************************************
// private to main loop
//**************************************
PRIVATE
 Intro_ID1;
 Intro_ID2;
 Intro_ID3;
 Intro_ID4;
 Intro_ID5;
 Intro_ID6;
 BgMusic;
 Option;
 Warning;
 EndThisGame;
 AlertID;


BEGIN


 //**************************************
 // general setup code
 // load up the graphic files, sound
 // and set the screen resolution etc.
 //**************************************

 DUMP_TYPE          = PARTIAL_DUMP;
                      LOAD_FNT("FNT\ODDITY\ODDITY.FNT");
 GameGraphicsID     = LOAD_FPG("FPG\ODDITY\ODDITY.FPG");
 Bgmusic            = LOAD_PCM("PCM\ODDITY\MAINSONG.PCM",1);
 HomeCraftLaser     = LOAD_PCM("PCM\LIBRARY\WAR\LASERS\LASER.PCM",0);
 EnemyLaser         = LOAD_PCM("PCM\LIBRARY\WAR\LASERS\LASER6.PCM",0);
 HomeMissleSound    = LOAD_PCM("PCM\LIBRARY\WAR\LASERS\LASER5.PCM",0);
 HomeCraftPickUp    = LOAD_PCM("PCM\LIBRARY\WAR\LASERS\LASER8.PCM",0);
 BossHit            = LOAD_PCM("PCM\LIBRARY\EFFECTS\VARIOUS\VOZROBOT.PCM",0);
 HomeCraftExplosion = LOAD_PCM("PCM\LIBRARY\WAR\EXPLOSIO\EXPLOS00.PCM",0);
 EnemyExplosion     = LOAD_PCM("PCM\LIBRARY\WAR\EXPLOSIO\EXPLOS10.PCM",0);
 BossVoice          = LOAD_PCM("PCM\LIBRARY\EFFECTS\ALIEN\ALIEN.PCM",0);
 EndThisGame        = -1;

 SET_MODE(m800x600);
 SET_FPS(30,0);
 SOUND(BgMusic,250,256);


 REPEAT

  //**************************************
  // draw the intro and main menu
  //**************************************
  CLEAR_SCREEN();
  PUT(0,31,400,300);
  Intro_ID1=WRITE(1,260,080,0,"Space Oddity");
  Intro_ID2=WRITE(1,240,200,0,"1 - Start Game");
  Intro_ID3=WRITE(1,240,260,0,"2 - Setup Controls");
  Intro_ID4=WRITE(1,240,320,0,"3 - Sound Control");
  Intro_ID5=WRITE(1,240,380,0,"X - Exit Game");
  Intro_ID6=WRITE(1,150,550,0,"Greg Martin - MicroResource");

  FADE_ON();
  LOOP
   SCAN_CODE=0;
   WHILE(SCAN_CODE==0)
    FRAME;
   END;

   IF(KEY(_1)) BREAK;  END
   IF(KEY(_2))         END // NO OPTION YET
   IF(KEY(_3))         END // NO OPTION YET
   IF(KEY(_x)) RETURN; END
  END;

  DELETE_TEXT(Intro_ID1);
  DELETE_TEXT(Intro_ID2);
  DELETE_TEXT(Intro_ID3);
  DELETE_TEXT(Intro_ID4);
  DELETE_TEXT(Intro_ID5);
  DELETE_TEXT(Intro_ID6);


  //**************************************
  // get ready for a game
  //**************************************
  FADE_OFF();
  Wave     = 0;
  Lives    = 3;
  BossLevel= 0;

  WRITE(1,0,0,0," Score");
  WRITE(1,610,0,0,"Lives");
  ScoreID=WRITE_INT(1,130,0,0,OFFSET CurrentScore);
  LivesID=WRITE_INT(1,710,0,0,OFFSET Lives);

  CLEAR_SCREEN();
  PUT(0,30,400,300);
  HomeCraftID = HomeCraft();
  HomeCraftKilledID=0;
  CraftIsImmune=0;


  FADE_ON();


  LOOP

   FRAME;

   //************************************//
   // do the big boss level              //
   //************************************//
   IF(BossLevel==1)

    // flash warning about the boss
    Warning=0;
    REPEAT
     AlertID=WRITE(1,240,180,0,"Incoming Boss");
     TIMER[9]=0;
     REPEAT
      FRAME;
     UNTIL(TIMER[9]>=20)
     DELETE_TEXT(AlertID);
     TIMER[9]=0;
     REPEAT
      FRAME;
     UNTIL(TIMER[9]>=20)
     Warning++;
     UNTIL(Warning>3);

    BossPower = Boss[Wave].Power;
    ShowBoss(Boss[Wave].XCord,Boss[Wave].YCord,Wave);
    BossLevel = 2;
   END

   //************************************//
   // warn the player about oncoming wave//
   // and load in the actual wave data   //
   //************************************//
   IF(StartNextWave<>0 AND BossLevel==0)

    // give a flash warning about the oncoming wave
    Warning=0;
    REPEAT
     AlertID=WRITE(1,240,180,0,"Incoming Wave");
     TIMER[9]=0;
     REPEAT
      FRAME;
     UNTIL(TIMER[9]>=20)
     DELETE_TEXT(AlertID);
     TIMER[9]=0;
     REPEAT
      FRAME;
     UNTIL(TIMER[9]>=20)
     Warning++;
     UNTIL(Warning>3);

    // lets load up the next wave and show it //
    TotalKilledInWave=0;
    IF(Wave>MAX_WAVES) Wave=0;END;
     FOR(Wave_Load=0;Wave_Load<MAX_INWAVE;Wave_Load++)
         Enemy(LevelWaves[Wave].xcord[Wave_Load],
               LevelWaves[Wave].ycord[Wave_Load],
               LevelWaves[Wave].graphiccode[Wave_Load],
               LevelWaves[Wave].value[Wave_Load]);
     END
     StartNextWave=0;
   END

   //******************************//
   // oh no! player has been killed//
   //******************************//
   IF(HomeCraftKilledID==1)

     // descrease the lives
     LIVES--;

     // make the player immune for 3 seconds
     IMMUNE();

     // if the lives have gone.....there gone
     IF(Lives<=0)
       LET_ME_ALONE();
       FADE_OFF(); CLEAR_SCREEN();
       PUT(0,31,400,300);
       Intro_ID1=WRITE(1,220,260,0,"G A M E  O V E R");
       FADE_ON();
       SCAN_CODE=0;
       TIMER[9]=0;
       REPEAT
        FRAME;
       UNTIL(TIMER[9]>500);
       SCAN_CODE=0;
       DELETE_TEXT(Intro_ID1);
       BREAK;
     ELSE
     // lets get it on
       HomeCraftKilledID=0;
       HomeCraftID = HomeCraft();
     END
   END


   //******************************//
   // wave has scrolled off screen //
   // or player has killed them all//
   // so start next wave process   //
   //******************************//
   IF(GET_ID(TYPE ENEMY)==0 AND GET_ID(TYPE ShowBoss)==0)
      Wave++;
      StartNextWave=1;
      TotalKilledInWave=0;
   END

   //******************************//
   // drop a random life pickup    //
   //******************************//
   IF(RAND(1,200*Lives)==150 AND GET_ID(TYPE LifeIcon)==0)
     LifeIcon(RAND(0,799),0);
   END

  END

 UNTIL(EndThisGame==1);

END

PROCESS IMMUNE();
BEGIN
 CraftIsImmune=1;
 TIMER[6]=0;
 REPEAT
  FRAME;
 UNTIL(TIMER[6]>500);
 CraftIsImmune=0;
END

PROCESS HOMECRAFT()

 PRIVATE
  HomeCraftSpeed;

BEGIN

 HomeCraftKilledID=0;
 GRAPH=HomeCraftType;
 X=300; Y=550; Missile_Flag=0;

 LOOP

  FRAME;

  IF(Missile_Flag==0)
    IF(KEY(_control) or KEY(_space))
      SOUND(HOMECRAFTLASER,200,256);
      missile_flag=1;
      ShotID=HomeShot(x,y-10);
     END
  END

  IF((SHIFT_STATUS AND 2)==2) HomeCraftSpeed=4; END
  IF((SHIFT_STATUS AND 2)<>2) HomeCraftSpeed=0; END

  IF(KEY(_right)) X+=4+HomeCraftSpeed; END
  IF(KEY(_Left))  X-=4+HomeCraftSpeed; END
  IF(KEY(_up))    Y-=4+HomeCraftSpeed; END
  IF(KEY(_down))  Y+=4+HomeCraftSpeed; END
  IF(X>762)  X=762; END
  IF(X<38)   X=38;  END
  IF(Y>570)  Y=570; END
  IF(Y<30)   Y=30;  END
  IF(CraftIsImmune==0)
   IF(COLLISION(TYPE Enemy))     BREAK; END
   IF(COLLISION(TYPE EnemyShot)) BREAK; END
   IF(COLLISION(TYPE ShowBoss))  BREAK; END
  END

 END

 SOUND(HomeCraftExplosion,250,256);
 FROM GRAPH=20 TO 29;
   FRAME;
 END
 HomeCraftKilledID=1;
 SIGNAL(ID,S_KILL);

END

PROCESS HOMESHOT(X,Y)
BEGIN
 GRAPH = 8;
 REPEAT
  y-=32;
 FRAME;
 UNTIL (OUT_REGION(ID,0) OR COLLISION(TYPE Enemy)
                         OR COLLISION(TYPE ShowBoss)
                         OR COLLISION(TYPE EnemyShot))
 Missile_Flag=0;
END

PROCESS SHOWBOSS(X,Y,BOSS_NO);
PRIVATE
 ALIENS_ANGLE;
 VoiceBREAK;
 MakeShot;
BEGIN
 X-=32;
 Y+=32;
 VoiceBREAK=100;SIZE=150;
 LOOP
  MakeShot=RAND(0,50);
  IF(MakeShot<=4 OR MakeShot>=48)
  EnemyShotID=EnemyShot(x,y+10,
                        HOMING_SHOTG,
                        Get_Angle(HomeCraftID),
                        HOMING_SHOT); END
  IF(VoiceBREAK==100)
  SOUND(BossVoice,200,300);
  VoiceBREAK=0;
  END
  ALIENS_ANGLE=GET_ANGLE(HomeCraftID);
  IF(GRAPH==BOSS[Boss_No].Graphic1)
    GRAPH=BOSS[Boss_No].Graphic2;
  ELSE
    GRAPH=BOSS[Boss_No].Graphic1;
  END
  X+=GET_DISTX(ALIENS_ANGLE,10);
  Y+=GET_DISTY(ALIENS_ANGLE,6);
  VoiceBREAK++;
  FRAME(280);
  IF(COLLISION(TYPE HomeShot)) SOUND(BossHit,200,156); BossPower--; END
  IF(BossPower<1)
   CurrentScore+=BOSS[Boss_No].Score;
   Lives++;
   BossLevel=0;
   StartNextWave=1;
   Wave++;
   RETURN;
  END;
 END
END

PROCESS ENEMY(X,Y,G_CODE,VALUE)
BEGIN

 GRAPH=g_code;
 EnemyShipScoreValue=Value;

 REPEAT
  y+=1;
  FRAME;
  IF(RAND(0,100)==50)
   IF(GRAPH==6)
     EnemyShotID=EnemyShot(x,y+10,
                           33,
                           NO_ANGLE,
                           NORMAL_SHOT); END
   IF(GRAPH==7)
     EnemyShotID=EnemyShot(x,y+10,
                           NORMAL_SHOTG,
                           NO_ANGLE,
                           NORMAL_SHOT); END
   IF(GRAPH==18)
     EnemyShotID=EnemyShot(x,y+10,
                           HOMING_SHOTG,
                           Get_Angle(HomeCraftID),
                           HOMING_SHOT); END
  END

  IF(COLLISION(TYPE HomeShot))

    SOUND(EnemyExplosion,150,400);
    TotalKilledInWave++;
    FROM GRAPH=10 TO 14;
     FRAME;
    END
    SIGNAL(ID,S_KILL);

    CurrentScore=CurrentScore+EnemyShipScoreValue;
    IF(TotalKilledInWave>=MAX_INWAVE)
      BossLevel=1;
      TotalKilledInWave=0;
     END

  END
  UNTIL(OUT_REGION(ID,0));

END

PROCESS LIFEICON(X,Y)
BEGIN
 GRAPH=19;
 REPEAT
  y+=4;
  FRAME;
  IF(COLLISION(TYPE HomeCraft))
   SOUND(HomeCraftPickup,200,356);
   Lives++;
   SIGNAL(ID,S_KILL);
  END
 UNTIL (OUT_REGION(ID,0) OR COLLISION(TYPE HomeCraft));
END

PROCESS ENEMYSHOT(X,Y,SHOT_GRAPHIC,BULLET_ANGLE,SHOT_TYPE)
BEGIN

 //********************************//
 // home craft is immune after kill//
 //********************************//
 IF(CraftIsImmune==1) RETURN; END

 //******************************//
 // normal missle                //
 //******************************//
 IF(SHOT_TYPE==1)
  SOUND(EnemyLaser,50,400);
  GRAPH=SHOT_GRAPHIC;
  REPEAT
   Y+=8;
   FRAME;
   IF(COLLISION(TYPE HomeShot))  CurrentScore+=5;END
  UNTIL (OUT_REGION(ID,0) OR COLLISION(TYPE HomeCraft)
                          OR COLLISION(TYPE HomeShot))
 END

 //******************************//
 // homing missle                //
 //******************************//
 IF(SHOT_TYPE==2)
  SOUND(HomeMissleSound,200,156);
  GRAPH=SHOT_GRAPHIC;
  X-=32;
  Y+=8;
  REPEAT
   X+=GET_DISTX(bullet_angle,16);
   Y+=GET_DISTY(bullet_angle,16);
   FRAME;
   IF(COLLISION(TYPE HomeShot)) CurrentScore+=5;END
  UNTIL (OUT_REGION(ID,0) OR COLLISION(TYPE HomeCraft)
                          OR COLLISION(TYPE HomeShot))
 END

END